<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for assetstbl
 */
class Assetstbl extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Export
    public $ExportDoc;

    // Fields
    public $Assetsid;
    public $MDA_Parent;
    public $MDA_id;
    public $Location_id;
    public $Asset_Status;
    public $Category_Temp;
    public $Make;
    public $Model;
    public $YearofManufacture;
    public $Colour;
    public $EngineNumber;
    public $ChasisNumber;
    public $CivilianPlateNumber;
    public $GovtPlateNumber;
    public $Asset_No;
    public $Details_of_Asset;
    public $Condition_Of_Asset;
    public $Custodian_id;
    public $Category;
    public $Category_Details;
    public $Date_of_Acquisition;
    public $Aquistion_Cost;
    public $Additional_Cost;
    public $Revaluation_Cost;
    public $Remarks;
    public $Created_on;
    public $Updated_on;
    public $Created_By;
    public $MDA_temp;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'assetstbl';
        $this->TableName = 'assetstbl';
        $this->TableType = 'TABLE';

        // Update Table
        $this->UpdateTable = "`assetstbl`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "landscape"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "landscape"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = 100; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = true; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // Assetsid
        $this->Assetsid = new DbField('assetstbl', 'assetstbl', 'x_Assetsid', 'Assetsid', '`Assetsid`', '`Assetsid`', 3, 11, -1, false, '`Assetsid`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->Assetsid->IsAutoIncrement = true; // Autoincrement field
        $this->Assetsid->IsPrimaryKey = true; // Primary key field
        $this->Assetsid->Sortable = true; // Allow sort
        $this->Assetsid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Assetsid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Assetsid->Param, "CustomMsg");
        $this->Fields['Assetsid'] = &$this->Assetsid;

        // MDA_Parent
        $this->MDA_Parent = new DbField('assetstbl', 'assetstbl', 'x_MDA_Parent', 'MDA_Parent', '`MDA_Parent`', '`MDA_Parent`', 200, 255, -1, false, '`MDA_Parent`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->MDA_Parent->Sortable = true; // Allow sort
        $this->MDA_Parent->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MDA_Parent->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->MDA_Parent->Lookup = new Lookup('MDA_Parent', 'mdatbl', true, 'Parent', ["Parent","","",""], [], ["x_MDA_id"], [], [], [], [], '`Parent`', '');
                break;
            default:
                $this->MDA_Parent->Lookup = new Lookup('MDA_Parent', 'mdatbl', true, 'Parent', ["Parent","","",""], [], ["x_MDA_id"], [], [], [], [], '`Parent`', '');
                break;
        }
        $this->MDA_Parent->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_Parent->Param, "CustomMsg");
        $this->Fields['MDA_Parent'] = &$this->MDA_Parent;

        // MDA_id
        $this->MDA_id = new DbField('assetstbl', 'assetstbl', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 11, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MDA_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA_Acronym","","",""], ["x_MDA_Parent"], ["x_Location_id","x_Custodian_id"], ["Parent"], ["x_Parent"], [], [], '`MDA_Acronym`', '');
                break;
            default:
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA_Acronym","","",""], ["x_MDA_Parent"], ["x_Location_id","x_Custodian_id"], ["Parent"], ["x_Parent"], [], [], '`MDA_Acronym`', '');
                break;
        }
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // Location_id
        $this->Location_id = new DbField('assetstbl', 'assetstbl', 'x_Location_id', 'Location_id', '`Location_id`', '`Location_id`', 3, 100, -1, false, '`Location_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Location_id->Nullable = false; // NOT NULL field
        $this->Location_id->Required = true; // Required field
        $this->Location_id->Sortable = true; // Allow sort
        $this->Location_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Location_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
            default:
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
        }
        $this->Location_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Location_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Location_id->Param, "CustomMsg");
        $this->Fields['Location_id'] = &$this->Location_id;

        // Asset_Status
        $this->Asset_Status = new DbField('assetstbl', 'assetstbl', 'x_Asset_Status', 'Asset_Status', '`Asset_Status`', '`Asset_Status`', 200, 255, -1, false, '`Asset_Status`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Asset_Status->Nullable = false; // NOT NULL field
        $this->Asset_Status->Sortable = true; // Allow sort
        $this->Asset_Status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Asset_Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Asset_Status->Lookup = new Lookup('Asset_Status', 'asset_staustbl', true, 'Status', ["Status","","",""], [], [], [], [], [], [], '`Statusid`', '');
                break;
            default:
                $this->Asset_Status->Lookup = new Lookup('Asset_Status', 'asset_staustbl', true, 'Status', ["Status","","",""], [], [], [], [], [], [], '`Statusid`', '');
                break;
        }
        $this->Asset_Status->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_Status->Param, "CustomMsg");
        $this->Asset_Status->AdvancedSearch->SearchValueDefault = 'Active';
        $this->Asset_Status->AdvancedSearch->SearchOperatorDefault = "LIKE";
        $this->Asset_Status->AdvancedSearch->SearchOperatorDefault2 = "";
        $this->Asset_Status->AdvancedSearch->SearchConditionDefault = "AND";
        $this->Fields['Asset_Status'] = &$this->Asset_Status;

        // Category_Temp
        $this->Category_Temp = new DbField('assetstbl', 'assetstbl', 'x_Category_Temp', 'Category_Temp', '`Category_Temp`', '`Category_Temp`', 200, 255, -1, false, '`Category_Temp`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Category_Temp->Nullable = false; // NOT NULL field
        $this->Category_Temp->Required = true; // Required field
        $this->Category_Temp->Sortable = true; // Allow sort
        $this->Category_Temp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Category_Temp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Category_Temp->Lookup = new Lookup('Category_Temp', 'categorydetailstbl', true, 'Category_Details', ["Category_Details","","",""], [], [], [], [], [], [], '`Category_Details`', '');
                break;
            default:
                $this->Category_Temp->Lookup = new Lookup('Category_Temp', 'categorydetailstbl', true, 'Category_Details', ["Category_Details","","",""], [], [], [], [], [], [], '`Category_Details`', '');
                break;
        }
        $this->Category_Temp->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_Temp->Param, "CustomMsg");
        $this->Fields['Category_Temp'] = &$this->Category_Temp;

        // Make
        $this->Make = new DbField('assetstbl', 'assetstbl', 'x_Make', 'Make', '`Make`', '`Make`', 200, 100, -1, false, '`Make`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Make->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->Make->Lookup = new Lookup('Make', 'make', true, 'id', ["code","","",""], [], ["x_Model"], [], [], [], [], '`code`', '');
                break;
            default:
                $this->Make->Lookup = new Lookup('Make', 'make', true, 'id', ["code","","",""], [], ["x_Model"], [], [], [], [], '`code`', '');
                break;
        }
        $this->Make->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Make->Param, "CustomMsg");
        $this->Fields['Make'] = &$this->Make;

        // Model
        $this->Model = new DbField('assetstbl', 'assetstbl', 'x_Model', 'Model', '`Model`', '`Model`', 200, 100, -1, false, '`Model`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Model->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->Model->Lookup = new Lookup('Model', 'model', true, 'id', ["code","","",""], ["x_Make"], [], ["make_id"], ["x_make_id"], [], [], '`code`', '');
                break;
            default:
                $this->Model->Lookup = new Lookup('Model', 'model', true, 'id', ["code","","",""], ["x_Make"], [], ["make_id"], ["x_make_id"], [], [], '`code`', '');
                break;
        }
        $this->Model->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Model->Param, "CustomMsg");
        $this->Fields['Model'] = &$this->Model;

        // Year of Manufacture
        $this->YearofManufacture = new DbField('assetstbl', 'assetstbl', 'x_YearofManufacture', 'Year of Manufacture', '`Year of Manufacture`', '`Year of Manufacture`', 3, 4, -1, false, '`Year of Manufacture`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->YearofManufacture->Sortable = true; // Allow sort
        $this->YearofManufacture->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->YearofManufacture->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->YearofManufacture->Param, "CustomMsg");
        $this->Fields['Year of Manufacture'] = &$this->YearofManufacture;

        // Colour
        $this->Colour = new DbField('assetstbl', 'assetstbl', 'x_Colour', 'Colour', '`Colour`', '`Colour`', 200, 50, -1, false, '`Colour`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Colour->Sortable = true; // Allow sort
        $this->Colour->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Colour->Param, "CustomMsg");
        $this->Fields['Colour'] = &$this->Colour;

        // Engine Number
        $this->EngineNumber = new DbField('assetstbl', 'assetstbl', 'x_EngineNumber', 'Engine Number', '`Engine Number`', '`Engine Number`', 200, 100, -1, false, '`Engine Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->EngineNumber->Sortable = true; // Allow sort
        $this->EngineNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->EngineNumber->Param, "CustomMsg");
        $this->Fields['Engine Number'] = &$this->EngineNumber;

        // Chasis Number
        $this->ChasisNumber = new DbField('assetstbl', 'assetstbl', 'x_ChasisNumber', 'Chasis Number', '`Chasis Number`', '`Chasis Number`', 200, 100, -1, false, '`Chasis Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->ChasisNumber->Sortable = true; // Allow sort
        $this->ChasisNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->ChasisNumber->Param, "CustomMsg");
        $this->Fields['Chasis Number'] = &$this->ChasisNumber;

        // Civilian Plate Number
        $this->CivilianPlateNumber = new DbField('assetstbl', 'assetstbl', 'x_CivilianPlateNumber', 'Civilian Plate Number', '`Civilian Plate Number`', '`Civilian Plate Number`', 200, 20, -1, false, '`Civilian Plate Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->CivilianPlateNumber->Sortable = true; // Allow sort
        $this->CivilianPlateNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->CivilianPlateNumber->Param, "CustomMsg");
        $this->Fields['Civilian Plate Number'] = &$this->CivilianPlateNumber;

        // Govt Plate Number
        $this->GovtPlateNumber = new DbField('assetstbl', 'assetstbl', 'x_GovtPlateNumber', 'Govt Plate Number', '`Govt Plate Number`', '`Govt Plate Number`', 200, 20, -1, false, '`Govt Plate Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->GovtPlateNumber->Sortable = true; // Allow sort
        $this->GovtPlateNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->GovtPlateNumber->Param, "CustomMsg");
        $this->Fields['Govt Plate Number'] = &$this->GovtPlateNumber;

        // Asset_No
        $this->Asset_No = new DbField('assetstbl', 'assetstbl', 'x_Asset_No', 'Asset_No', '`Asset_No`', '`Asset_No`', 200, 255, -1, false, '`Asset_No`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_No->Sortable = true; // Allow sort
        $this->Asset_No->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_No->Param, "CustomMsg");
        $this->Fields['Asset_No'] = &$this->Asset_No;

        // Details_of_Asset
        $this->Details_of_Asset = new DbField('assetstbl', 'assetstbl', 'x_Details_of_Asset', 'Details_of_Asset', '`Details_of_Asset`', '`Details_of_Asset`', 200, 255, -1, false, '`Details_of_Asset`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Details_of_Asset->Nullable = false; // NOT NULL field
        $this->Details_of_Asset->Required = true; // Required field
        $this->Details_of_Asset->Sortable = true; // Allow sort
        $this->Details_of_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Details_of_Asset->Param, "CustomMsg");
        $this->Fields['Details_of_Asset'] = &$this->Details_of_Asset;

        // Condition_Of_Asset
        $this->Condition_Of_Asset = new DbField('assetstbl', 'assetstbl', 'x_Condition_Of_Asset', 'Condition_Of_Asset', '`Condition_Of_Asset`', '`Condition_Of_Asset`', 200, 255, -1, false, '`Condition_Of_Asset`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Condition_Of_Asset->Nullable = false; // NOT NULL field
        $this->Condition_Of_Asset->Sortable = true; // Allow sort
        $this->Condition_Of_Asset->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Condition_Of_Asset->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Condition_Of_Asset->Lookup = new Lookup('Condition_Of_Asset', 'condition_of_assettbl', true, 'status', ["status","","",""], [], [], [], [], [], [], '`statusid`', '');
                break;
            default:
                $this->Condition_Of_Asset->Lookup = new Lookup('Condition_Of_Asset', 'condition_of_assettbl', true, 'status', ["status","","",""], [], [], [], [], [], [], '`statusid`', '');
                break;
        }
        $this->Condition_Of_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Condition_Of_Asset->Param, "CustomMsg");
        $this->Condition_Of_Asset->AdvancedSearch->SearchValueDefault = 'Good';
        $this->Condition_Of_Asset->AdvancedSearch->SearchOperatorDefault = "LIKE";
        $this->Condition_Of_Asset->AdvancedSearch->SearchOperatorDefault2 = "";
        $this->Condition_Of_Asset->AdvancedSearch->SearchConditionDefault = "AND";
        $this->Fields['Condition_Of_Asset'] = &$this->Condition_Of_Asset;

        // Custodian_id
        $this->Custodian_id = new DbField('assetstbl', 'assetstbl', 'x_Custodian_id', 'Custodian_id', '`Custodian_id`', '`Custodian_id`', 3, 100, -1, false, '`Custodian_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Custodian_id->Sortable = true; // Allow sort
        $this->Custodian_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Custodian_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Custodian_id->Lookup = new Lookup('Custodian_id', 'custodianstbl', false, 'id', ["Lastname","Firstname","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '', '');
                break;
            default:
                $this->Custodian_id->Lookup = new Lookup('Custodian_id', 'custodianstbl', false, 'id', ["Lastname","Firstname","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '', '');
                break;
        }
        $this->Custodian_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Custodian_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Custodian_id->Param, "CustomMsg");
        $this->Fields['Custodian_id'] = &$this->Custodian_id;

        // Category
        $this->Category = new DbField('assetstbl', 'assetstbl', 'x_Category', 'Category', '`Category`', '`Category`', 200, 20, -1, false, '`Category`', false, false, false, 'FORMATTED TEXT', 'CHECKBOX');
        $this->Category->Nullable = false; // NOT NULL field
        $this->Category->Required = true; // Required field
        $this->Category->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->Category->Lookup = new Lookup('Category', 'categorytbl', false, 'Categoryid', ["Category","","",""], [], ["x_Category_Details"], [], [], ["Categoryid"], ["x_Assetsid"], '`Category`', '');
                break;
            default:
                $this->Category->Lookup = new Lookup('Category', 'categorytbl', false, 'Categoryid', ["Category","","",""], [], ["x_Category_Details"], [], [], ["Categoryid"], ["x_Assetsid"], '`Category`', '');
                break;
        }
        $this->Category->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category->Param, "CustomMsg");
        $this->Fields['Category'] = &$this->Category;

        // Category_Details
        $this->Category_Details = new DbField('assetstbl', 'assetstbl', 'x_Category_Details', 'Category_Details', '`Category_Details`', '`Category_Details`', 200, 255, -1, false, '`Category_Details`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Category_Details->Sortable = true; // Allow sort
        $this->Category_Details->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Category_Details->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Category_Details->Lookup = new Lookup('Category_Details', 'categorydetailstbl', false, 'Category_Details', ["Category_Details","","",""], ["x_Category[]"], [], ["Category_id"], ["x_Category_id"], ["Category_id"], ["x_Category[]"], '`Category_Details`', '');
                break;
            default:
                $this->Category_Details->Lookup = new Lookup('Category_Details', 'categorydetailstbl', false, 'Category_Details', ["Category_Details","","",""], ["x_Category[]"], [], ["Category_id"], ["x_Category_id"], ["Category_id"], ["x_Category[]"], '`Category_Details`', '');
                break;
        }
        $this->Category_Details->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_Details->Param, "CustomMsg");
        $this->Fields['Category_Details'] = &$this->Category_Details;

        // Date_of_Acquisition
        $this->Date_of_Acquisition = new DbField('assetstbl', 'assetstbl', 'x_Date_of_Acquisition', 'Date_of_Acquisition', '`Date_of_Acquisition`', CastDateFieldForLike("`Date_of_Acquisition`", 0, "DB"), 133, 10, 0, false, '`Date_of_Acquisition`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Date_of_Acquisition->Nullable = false; // NOT NULL field
        $this->Date_of_Acquisition->Required = true; // Required field
        $this->Date_of_Acquisition->Sortable = true; // Allow sort
        $this->Date_of_Acquisition->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Date_of_Acquisition->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Date_of_Acquisition->Param, "CustomMsg");
        $this->Fields['Date_of_Acquisition'] = &$this->Date_of_Acquisition;

        // Aquistion_Cost
        $this->Aquistion_Cost = new DbField('assetstbl', 'assetstbl', 'x_Aquistion_Cost', 'Aquistion_Cost', '`Aquistion_Cost`', '`Aquistion_Cost`', 5, 22, -1, false, '`Aquistion_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Aquistion_Cost->Nullable = false; // NOT NULL field
        $this->Aquistion_Cost->Required = true; // Required field
        $this->Aquistion_Cost->Sortable = true; // Allow sort
        $this->Aquistion_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Aquistion_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Aquistion_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Aquistion_Cost->Param, "CustomMsg");
        $this->Fields['Aquistion_Cost'] = &$this->Aquistion_Cost;

        // Additional_Cost
        $this->Additional_Cost = new DbField('assetstbl', 'assetstbl', 'x_Additional_Cost', 'Additional_Cost', '`Additional_Cost`', '`Additional_Cost`', 5, 22, -1, false, '`Additional_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Additional_Cost->Sortable = true; // Allow sort
        $this->Additional_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Additional_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Additional_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Additional_Cost->Param, "CustomMsg");
        $this->Fields['Additional_Cost'] = &$this->Additional_Cost;

        // Revaluation_Cost
        $this->Revaluation_Cost = new DbField('assetstbl', 'assetstbl', 'x_Revaluation_Cost', 'Revaluation_Cost', '`Revaluation_Cost`', '`Revaluation_Cost`', 5, 22, -1, false, '`Revaluation_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Revaluation_Cost->Sortable = true; // Allow sort
        $this->Revaluation_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Revaluation_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Revaluation_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Revaluation_Cost->Param, "CustomMsg");
        $this->Fields['Revaluation_Cost'] = &$this->Revaluation_Cost;

        // Remarks
        $this->Remarks = new DbField('assetstbl', 'assetstbl', 'x_Remarks', 'Remarks', '`Remarks`', '`Remarks`', 201, -1, -1, false, '`Remarks`', false, false, false, 'FORMATTED TEXT', 'TEXTAREA');
        $this->Remarks->Sortable = true; // Allow sort
        $this->Remarks->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Remarks->Param, "CustomMsg");
        $this->Fields['Remarks'] = &$this->Remarks;

        // Created_on
        $this->Created_on = new DbField('assetstbl', 'assetstbl', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 0, "DB"), 133, 10, 0, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Fields['Created_on'] = &$this->Created_on;

        // Updated_on
        $this->Updated_on = new DbField('assetstbl', 'assetstbl', 'x_Updated_on', 'Updated_on', '`Updated_on`', CastDateFieldForLike("`Updated_on`", 0, "DB"), 133, 10, 0, false, '`Updated_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Updated_on->Sortable = true; // Allow sort
        $this->Updated_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Updated_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Updated_on->Param, "CustomMsg");
        $this->Fields['Updated_on'] = &$this->Updated_on;

        // Created_By
        $this->Created_By = new DbField('assetstbl', 'assetstbl', 'x_Created_By', 'Created_By', '`Created_By`', '`Created_By`', 3, 11, -1, false, '`Created_By`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_By->Sortable = true; // Allow sort
        $this->Created_By->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Created_By->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_By->Param, "CustomMsg");
        $this->Fields['Created_By'] = &$this->Created_By;

        // MDA_temp
        $this->MDA_temp = new DbField('assetstbl', 'assetstbl', 'x_MDA_temp', 'MDA_temp', '`MDA_temp`', '`MDA_temp`', 200, 100, -1, false, '`MDA_temp`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->MDA_temp->Sortable = false; // Allow sort
        $this->MDA_temp->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_temp->Param, "CustomMsg");
        $this->Fields['MDA_temp'] = &$this->MDA_temp;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`assetstbl`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $filter = $this->addUserIDFilter($filter);
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->Assetsid->setDbValue($conn->lastInsertId());
            $rs['Assetsid'] = $this->Assetsid->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'Assetsid';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('Assetsid', $rs)) {
                AddFilter($where, QuotedName('Assetsid', $this->Dbid) . '=' . QuotedValue($rs['Assetsid'], $this->Assetsid->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Assetsid->DbValue = $row['Assetsid'];
        $this->MDA_Parent->DbValue = $row['MDA_Parent'];
        $this->MDA_id->DbValue = $row['MDA_id'];
        $this->Location_id->DbValue = $row['Location_id'];
        $this->Asset_Status->DbValue = $row['Asset_Status'];
        $this->Category_Temp->DbValue = $row['Category_Temp'];
        $this->Make->DbValue = $row['Make'];
        $this->Model->DbValue = $row['Model'];
        $this->YearofManufacture->DbValue = $row['Year of Manufacture'];
        $this->Colour->DbValue = $row['Colour'];
        $this->EngineNumber->DbValue = $row['Engine Number'];
        $this->ChasisNumber->DbValue = $row['Chasis Number'];
        $this->CivilianPlateNumber->DbValue = $row['Civilian Plate Number'];
        $this->GovtPlateNumber->DbValue = $row['Govt Plate Number'];
        $this->Asset_No->DbValue = $row['Asset_No'];
        $this->Details_of_Asset->DbValue = $row['Details_of_Asset'];
        $this->Condition_Of_Asset->DbValue = $row['Condition_Of_Asset'];
        $this->Custodian_id->DbValue = $row['Custodian_id'];
        $this->Category->DbValue = $row['Category'];
        $this->Category_Details->DbValue = $row['Category_Details'];
        $this->Date_of_Acquisition->DbValue = $row['Date_of_Acquisition'];
        $this->Aquistion_Cost->DbValue = $row['Aquistion_Cost'];
        $this->Additional_Cost->DbValue = $row['Additional_Cost'];
        $this->Revaluation_Cost->DbValue = $row['Revaluation_Cost'];
        $this->Remarks->DbValue = $row['Remarks'];
        $this->Created_on->DbValue = $row['Created_on'];
        $this->Updated_on->DbValue = $row['Updated_on'];
        $this->Created_By->DbValue = $row['Created_By'];
        $this->MDA_temp->DbValue = $row['MDA_temp'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`Assetsid` = @Assetsid@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->Assetsid->CurrentValue : $this->Assetsid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->Assetsid->CurrentValue = $keys[0];
            } else {
                $this->Assetsid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('Assetsid', $row) ? $row['Assetsid'] : null;
        } else {
            $val = $this->Assetsid->OldValue !== null ? $this->Assetsid->OldValue : $this->Assetsid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@Assetsid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("assetstbllist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "assetstblview") {
            return $Language->phrase("View");
        } elseif ($pageName == "assetstbledit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "assetstbladd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "AssetstblView";
            case Config("API_ADD_ACTION"):
                return "AssetstblAdd";
            case Config("API_EDIT_ACTION"):
                return "AssetstblEdit";
            case Config("API_DELETE_ACTION"):
                return "AssetstblDelete";
            case Config("API_LIST_ACTION"):
                return "AssetstblList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "assetstbllist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("assetstblview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("assetstblview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "assetstbladd?" . $this->getUrlParm($parm);
        } else {
            $url = "assetstbladd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("assetstbledit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("assetstbladd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("assetstbldelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "Assetsid:" . JsonEncode($this->Assetsid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->Assetsid->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->Assetsid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("Assetsid") ?? Route("Assetsid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->Assetsid->CurrentValue = $key;
            } else {
                $this->Assetsid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Assetsid->setDbValue($row['Assetsid']);
        $this->MDA_Parent->setDbValue($row['MDA_Parent']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Location_id->setDbValue($row['Location_id']);
        $this->Asset_Status->setDbValue($row['Asset_Status']);
        $this->Category_Temp->setDbValue($row['Category_Temp']);
        $this->Make->setDbValue($row['Make']);
        $this->Model->setDbValue($row['Model']);
        $this->YearofManufacture->setDbValue($row['Year of Manufacture']);
        $this->Colour->setDbValue($row['Colour']);
        $this->EngineNumber->setDbValue($row['Engine Number']);
        $this->ChasisNumber->setDbValue($row['Chasis Number']);
        $this->CivilianPlateNumber->setDbValue($row['Civilian Plate Number']);
        $this->GovtPlateNumber->setDbValue($row['Govt Plate Number']);
        $this->Asset_No->setDbValue($row['Asset_No']);
        $this->Details_of_Asset->setDbValue($row['Details_of_Asset']);
        $this->Condition_Of_Asset->setDbValue($row['Condition_Of_Asset']);
        $this->Custodian_id->setDbValue($row['Custodian_id']);
        $this->Category->setDbValue($row['Category']);
        $this->Category_Details->setDbValue($row['Category_Details']);
        $this->Date_of_Acquisition->setDbValue($row['Date_of_Acquisition']);
        $this->Aquistion_Cost->setDbValue($row['Aquistion_Cost']);
        $this->Additional_Cost->setDbValue($row['Additional_Cost']);
        $this->Revaluation_Cost->setDbValue($row['Revaluation_Cost']);
        $this->Remarks->setDbValue($row['Remarks']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->MDA_temp->setDbValue($row['MDA_temp']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Assetsid
        $this->Assetsid->CellCssStyle = "min-width: 10px; white-space: nowrap;";

        // MDA_Parent

        // MDA_id
        $this->MDA_id->CellCssStyle = "min-width: 100%;";

        // Location_id

        // Asset_Status

        // Category_Temp

        // Make

        // Model

        // Year of Manufacture

        // Colour

        // Engine Number

        // Chasis Number

        // Civilian Plate Number

        // Govt Plate Number

        // Asset_No
        $this->Asset_No->CellCssStyle = "min-width: 100px;";

        // Details_of_Asset
        $this->Details_of_Asset->CellCssStyle = "min-width: 100%;";

        // Condition_Of_Asset

        // Custodian_id
        $this->Custodian_id->CellCssStyle = "min-width: 100%;";

        // Category
        $this->Category->CellCssStyle = "min-width: 100%;";

        // Category_Details
        $this->Category_Details->CellCssStyle = "min-width: 100%;";

        // Date_of_Acquisition

        // Aquistion_Cost
        $this->Aquistion_Cost->CellCssStyle = "min-width: 100%;";

        // Additional_Cost
        $this->Additional_Cost->CellCssStyle = "min-width: 100%;";

        // Revaluation_Cost
        $this->Revaluation_Cost->CellCssStyle = "min-width: 100%;";

        // Remarks
        $this->Remarks->CellCssStyle = "min-width: 100%;";

        // Created_on

        // Updated_on

        // Created_By

        // MDA_temp

        // Assetsid
        $this->Assetsid->ViewValue = $this->Assetsid->CurrentValue;
        $this->Assetsid->CellCssStyle .= "text-align: right;";
        $this->Assetsid->ViewCustomAttributes = "";

        // MDA_Parent
        $curVal = trim(strval($this->MDA_Parent->CurrentValue));
        if ($curVal != "") {
            $this->MDA_Parent->ViewValue = $this->MDA_Parent->lookupCacheOption($curVal);
            if ($this->MDA_Parent->ViewValue === null) { // Lookup from database
                $filterWrk = "`Parent`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->MDA_Parent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->MDA_Parent->Lookup->renderViewRow($rswrk[0]);
                    $this->MDA_Parent->ViewValue = $this->MDA_Parent->displayValue($arwrk);
                } else {
                    $this->MDA_Parent->ViewValue = $this->MDA_Parent->CurrentValue;
                }
            }
        } else {
            $this->MDA_Parent->ViewValue = null;
        }
        $this->MDA_Parent->ViewCustomAttributes = "";

        // MDA_id
        $curVal = trim(strval($this->MDA_id->CurrentValue));
        if ($curVal != "") {
            $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
            if ($this->MDA_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                    $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                } else {
                    $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                }
            }
        } else {
            $this->MDA_id->ViewValue = null;
        }
        $this->MDA_id->ViewCustomAttributes = "";

        // Location_id
        $curVal = trim(strval($this->Location_id->CurrentValue));
        if ($curVal != "") {
            $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
            if ($this->Location_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                    $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                } else {
                    $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                }
            }
        } else {
            $this->Location_id->ViewValue = null;
        }
        $this->Location_id->ViewCustomAttributes = "";

        // Asset_Status
        $curVal = trim(strval($this->Asset_Status->CurrentValue));
        if ($curVal != "") {
            $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
            if ($this->Asset_Status->ViewValue === null) { // Lookup from database
                $filterWrk = "`Status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->Asset_Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Asset_Status->Lookup->renderViewRow($rswrk[0]);
                    $this->Asset_Status->ViewValue = $this->Asset_Status->displayValue($arwrk);
                } else {
                    $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
                }
            }
        } else {
            $this->Asset_Status->ViewValue = null;
        }
        $this->Asset_Status->ViewCustomAttributes = "";

        // Category_Temp
        $curVal = trim(strval($this->Category_Temp->CurrentValue));
        if ($curVal != "") {
            $this->Category_Temp->ViewValue = $this->Category_Temp->lookupCacheOption($curVal);
            if ($this->Category_Temp->ViewValue === null) { // Lookup from database
                $filterWrk = "`Category_Details`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->Category_Temp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Category_Temp->Lookup->renderViewRow($rswrk[0]);
                    $this->Category_Temp->ViewValue = $this->Category_Temp->displayValue($arwrk);
                } else {
                    $this->Category_Temp->ViewValue = $this->Category_Temp->CurrentValue;
                }
            }
        } else {
            $this->Category_Temp->ViewValue = null;
        }
        $this->Category_Temp->ViewCustomAttributes = "";

        // Make
        $this->Make->ViewValue = $this->Make->CurrentValue;
        $curVal = trim(strval($this->Make->CurrentValue));
        if ($curVal != "") {
            $this->Make->ViewValue = $this->Make->lookupCacheOption($curVal);
            if ($this->Make->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Make->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Make->Lookup->renderViewRow($rswrk[0]);
                    $this->Make->ViewValue = $this->Make->displayValue($arwrk);
                } else {
                    $this->Make->ViewValue = $this->Make->CurrentValue;
                }
            }
        } else {
            $this->Make->ViewValue = null;
        }
        $this->Make->ViewCustomAttributes = "";

        // Model
        $this->Model->ViewValue = $this->Model->CurrentValue;
        $curVal = trim(strval($this->Model->CurrentValue));
        if ($curVal != "") {
            $this->Model->ViewValue = $this->Model->lookupCacheOption($curVal);
            if ($this->Model->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Model->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Model->Lookup->renderViewRow($rswrk[0]);
                    $this->Model->ViewValue = $this->Model->displayValue($arwrk);
                } else {
                    $this->Model->ViewValue = $this->Model->CurrentValue;
                }
            }
        } else {
            $this->Model->ViewValue = null;
        }
        $this->Model->ViewCustomAttributes = "";

        // Year of Manufacture
        $this->YearofManufacture->ViewValue = $this->YearofManufacture->CurrentValue;
        $this->YearofManufacture->ViewCustomAttributes = "";

        // Colour
        $this->Colour->ViewValue = $this->Colour->CurrentValue;
        $this->Colour->ViewCustomAttributes = "";

        // Engine Number
        $this->EngineNumber->ViewValue = $this->EngineNumber->CurrentValue;
        $this->EngineNumber->ViewCustomAttributes = "";

        // Chasis Number
        $this->ChasisNumber->ViewValue = $this->ChasisNumber->CurrentValue;
        $this->ChasisNumber->ViewCustomAttributes = "";

        // Civilian Plate Number
        $this->CivilianPlateNumber->ViewValue = $this->CivilianPlateNumber->CurrentValue;
        $this->CivilianPlateNumber->ViewCustomAttributes = "";

        // Govt Plate Number
        $this->GovtPlateNumber->ViewValue = $this->GovtPlateNumber->CurrentValue;
        $this->GovtPlateNumber->ViewCustomAttributes = "";

        // Asset_No
        $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
        $this->Asset_No->ViewCustomAttributes = "";

        // Details_of_Asset
        $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
        $this->Details_of_Asset->CellCssStyle .= "text-align: left;";
        $this->Details_of_Asset->ViewCustomAttributes = "";

        // Condition_Of_Asset
        $curVal = trim(strval($this->Condition_Of_Asset->CurrentValue));
        if ($curVal != "") {
            $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
            if ($this->Condition_Of_Asset->ViewValue === null) { // Lookup from database
                $filterWrk = "`status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Condition_Of_Asset->Lookup->renderViewRow($rswrk[0]);
                    $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->displayValue($arwrk);
                } else {
                    $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
                }
            }
        } else {
            $this->Condition_Of_Asset->ViewValue = null;
        }
        $this->Condition_Of_Asset->ViewCustomAttributes = "";

        // Custodian_id
        $curVal = trim(strval($this->Custodian_id->CurrentValue));
        if ($curVal != "") {
            $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
            if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Custodian_id->Lookup->renderViewRow($rswrk[0]);
                    $this->Custodian_id->ViewValue = $this->Custodian_id->displayValue($arwrk);
                } else {
                    $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                }
            }
        } else {
            $this->Custodian_id->ViewValue = null;
        }
        $this->Custodian_id->ViewCustomAttributes = "";

        // Category
        $curVal = trim(strval($this->Category->CurrentValue));
        if ($curVal != "") {
            $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
            if ($this->Category->ViewValue === null) { // Lookup from database
                $arwrk = explode(",", $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    if ($filterWrk != "") {
                        $filterWrk .= " OR ";
                    }
                    $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->Category->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->Category->Lookup->renderViewRow($row);
                        $this->Category->ViewValue->add($this->Category->displayValue($arwrk));
                    }
                } else {
                    $this->Category->ViewValue = $this->Category->CurrentValue;
                }
            }
        } else {
            $this->Category->ViewValue = null;
        }
        $this->Category->CellCssStyle .= "text-align: left;";
        $this->Category->ViewCustomAttributes = "";

        // Category_Details
        $curVal = trim(strval($this->Category_Details->CurrentValue));
        if ($curVal != "") {
            $this->Category_Details->ViewValue = $this->Category_Details->lookupCacheOption($curVal);
            if ($this->Category_Details->ViewValue === null) { // Lookup from database
                $filterWrk = "`Category_Details`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                $sqlWrk = $this->Category_Details->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Category_Details->Lookup->renderViewRow($rswrk[0]);
                    $this->Category_Details->ViewValue = $this->Category_Details->displayValue($arwrk);
                } else {
                    $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
                }
            }
        } else {
            $this->Category_Details->ViewValue = null;
        }
        $this->Category_Details->ViewCustomAttributes = "";

        // Date_of_Acquisition
        $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
        $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
        $this->Date_of_Acquisition->ViewCustomAttributes = "";

        // Aquistion_Cost
        $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
        $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -1, -2);
        $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
        $this->Aquistion_Cost->ViewCustomAttributes = "";

        // Additional_Cost
        $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
        $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
        $this->Additional_Cost->CellCssStyle .= "text-align: right;";
        $this->Additional_Cost->ViewCustomAttributes = "";

        // Revaluation_Cost
        $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
        $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
        $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
        $this->Revaluation_Cost->ViewCustomAttributes = "";

        // Remarks
        $this->Remarks->ViewValue = $this->Remarks->CurrentValue;
        $this->Remarks->CellCssStyle .= "text-align: left;";
        $this->Remarks->ViewCustomAttributes = "";

        // Created_on
        $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
        $this->Created_on->ViewCustomAttributes = "";

        // Updated_on
        $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
        $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
        $this->Updated_on->ViewCustomAttributes = "";

        // Created_By
        $this->Created_By->ViewValue = $this->Created_By->CurrentValue;
        $this->Created_By->ViewValue = FormatNumber($this->Created_By->ViewValue, 0, -2, -2, -2);
        $this->Created_By->ViewCustomAttributes = "";

        // MDA_temp
        $this->MDA_temp->ViewValue = $this->MDA_temp->CurrentValue;
        $this->MDA_temp->ViewCustomAttributes = "";

        // Assetsid
        $this->Assetsid->LinkCustomAttributes = "";
        $this->Assetsid->HrefValue = "";
        $this->Assetsid->TooltipValue = "";

        // MDA_Parent
        $this->MDA_Parent->LinkCustomAttributes = "";
        $this->MDA_Parent->HrefValue = "";
        $this->MDA_Parent->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // Location_id
        $this->Location_id->LinkCustomAttributes = "";
        $this->Location_id->HrefValue = "";
        $this->Location_id->TooltipValue = "";

        // Asset_Status
        $this->Asset_Status->LinkCustomAttributes = "";
        $this->Asset_Status->HrefValue = "";
        $this->Asset_Status->TooltipValue = "";

        // Category_Temp
        $this->Category_Temp->LinkCustomAttributes = "";
        $this->Category_Temp->HrefValue = "";
        $this->Category_Temp->TooltipValue = "";

        // Make
        $this->Make->LinkCustomAttributes = "";
        $this->Make->HrefValue = "";
        $this->Make->TooltipValue = "";

        // Model
        $this->Model->LinkCustomAttributes = "";
        $this->Model->HrefValue = "";
        $this->Model->TooltipValue = "";

        // Year of Manufacture
        $this->YearofManufacture->LinkCustomAttributes = "";
        $this->YearofManufacture->HrefValue = "";
        $this->YearofManufacture->TooltipValue = "";

        // Colour
        $this->Colour->LinkCustomAttributes = "";
        $this->Colour->HrefValue = "";
        $this->Colour->TooltipValue = "";

        // Engine Number
        $this->EngineNumber->LinkCustomAttributes = "";
        $this->EngineNumber->HrefValue = "";
        $this->EngineNumber->TooltipValue = "";

        // Chasis Number
        $this->ChasisNumber->LinkCustomAttributes = "";
        $this->ChasisNumber->HrefValue = "";
        $this->ChasisNumber->TooltipValue = "";

        // Civilian Plate Number
        $this->CivilianPlateNumber->LinkCustomAttributes = "";
        $this->CivilianPlateNumber->HrefValue = "";
        $this->CivilianPlateNumber->TooltipValue = "";

        // Govt Plate Number
        $this->GovtPlateNumber->LinkCustomAttributes = "";
        $this->GovtPlateNumber->HrefValue = "";
        $this->GovtPlateNumber->TooltipValue = "";

        // Asset_No
        $this->Asset_No->LinkCustomAttributes = "";
        $this->Asset_No->HrefValue = "";
        $this->Asset_No->TooltipValue = "";

        // Details_of_Asset
        $this->Details_of_Asset->LinkCustomAttributes = "";
        $this->Details_of_Asset->HrefValue = "";
        $this->Details_of_Asset->TooltipValue = "";

        // Condition_Of_Asset
        $this->Condition_Of_Asset->LinkCustomAttributes = "";
        $this->Condition_Of_Asset->HrefValue = "";
        $this->Condition_Of_Asset->TooltipValue = "";

        // Custodian_id
        $this->Custodian_id->LinkCustomAttributes = "";
        $this->Custodian_id->HrefValue = "";
        $this->Custodian_id->TooltipValue = "";

        // Category
        $this->Category->LinkCustomAttributes = "";
        $this->Category->HrefValue = "";
        $this->Category->TooltipValue = "";

        // Category_Details
        $this->Category_Details->LinkCustomAttributes = "";
        $this->Category_Details->HrefValue = "";
        $this->Category_Details->TooltipValue = "";

        // Date_of_Acquisition
        $this->Date_of_Acquisition->LinkCustomAttributes = "";
        $this->Date_of_Acquisition->HrefValue = "";
        $this->Date_of_Acquisition->TooltipValue = "";

        // Aquistion_Cost
        $this->Aquistion_Cost->LinkCustomAttributes = "";
        $this->Aquistion_Cost->HrefValue = "";
        $this->Aquistion_Cost->TooltipValue = "";

        // Additional_Cost
        $this->Additional_Cost->LinkCustomAttributes = "";
        $this->Additional_Cost->HrefValue = "";
        $this->Additional_Cost->TooltipValue = "";

        // Revaluation_Cost
        $this->Revaluation_Cost->LinkCustomAttributes = "";
        $this->Revaluation_Cost->HrefValue = "";
        $this->Revaluation_Cost->TooltipValue = "";

        // Remarks
        $this->Remarks->LinkCustomAttributes = "";
        $this->Remarks->HrefValue = "";
        $this->Remarks->TooltipValue = "";

        // Created_on
        $this->Created_on->LinkCustomAttributes = "";
        $this->Created_on->HrefValue = "";
        $this->Created_on->TooltipValue = "";

        // Updated_on
        $this->Updated_on->LinkCustomAttributes = "";
        $this->Updated_on->HrefValue = "";
        $this->Updated_on->TooltipValue = "";

        // Created_By
        $this->Created_By->LinkCustomAttributes = "";
        $this->Created_By->HrefValue = "";
        $this->Created_By->TooltipValue = "";

        // MDA_temp
        $this->MDA_temp->LinkCustomAttributes = "";
        $this->MDA_temp->HrefValue = "";
        $this->MDA_temp->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Assetsid
        $this->Assetsid->EditAttrs["class"] = "form-control";
        $this->Assetsid->EditCustomAttributes = "";
        $this->Assetsid->EditValue = $this->Assetsid->CurrentValue;
        $this->Assetsid->CellCssStyle .= "text-align: right;";
        $this->Assetsid->ViewCustomAttributes = "";

        // MDA_Parent
        $this->MDA_Parent->EditAttrs["class"] = "form-control";
        $this->MDA_Parent->EditCustomAttributes = "";
        $this->MDA_Parent->PlaceHolder = RemoveHtml($this->MDA_Parent->caption());

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("info")) { // Non system admin
            $this->MDA_id->CurrentValue = CurrentUserID();
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->EditValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->EditValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";
        } else {
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
        }

        // Location_id
        $this->Location_id->EditAttrs["class"] = "form-control";
        $this->Location_id->EditCustomAttributes = "";
        $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

        // Asset_Status
        $this->Asset_Status->EditAttrs["class"] = "form-control";
        $this->Asset_Status->EditCustomAttributes = "";
        $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

        // Category_Temp
        $this->Category_Temp->EditAttrs["class"] = "form-control";
        $this->Category_Temp->EditCustomAttributes = "";
        $this->Category_Temp->PlaceHolder = RemoveHtml($this->Category_Temp->caption());

        // Make
        $this->Make->EditAttrs["class"] = "form-control";
        $this->Make->EditCustomAttributes = "";
        if (!$this->Make->Raw) {
            $this->Make->CurrentValue = HtmlDecode($this->Make->CurrentValue);
        }
        $this->Make->EditValue = $this->Make->CurrentValue;
        $this->Make->PlaceHolder = RemoveHtml($this->Make->caption());

        // Model
        $this->Model->EditAttrs["class"] = "form-control";
        $this->Model->EditCustomAttributes = "";
        if (!$this->Model->Raw) {
            $this->Model->CurrentValue = HtmlDecode($this->Model->CurrentValue);
        }
        $this->Model->EditValue = $this->Model->CurrentValue;
        $this->Model->PlaceHolder = RemoveHtml($this->Model->caption());

        // Year of Manufacture
        $this->YearofManufacture->EditAttrs["class"] = "form-control";
        $this->YearofManufacture->EditCustomAttributes = "";
        $this->YearofManufacture->EditValue = $this->YearofManufacture->CurrentValue;
        $this->YearofManufacture->PlaceHolder = RemoveHtml($this->YearofManufacture->caption());

        // Colour
        $this->Colour->EditAttrs["class"] = "form-control";
        $this->Colour->EditCustomAttributes = "";
        if (!$this->Colour->Raw) {
            $this->Colour->CurrentValue = HtmlDecode($this->Colour->CurrentValue);
        }
        $this->Colour->EditValue = $this->Colour->CurrentValue;
        $this->Colour->PlaceHolder = RemoveHtml($this->Colour->caption());

        // Engine Number
        $this->EngineNumber->EditAttrs["class"] = "form-control";
        $this->EngineNumber->EditCustomAttributes = "";
        if (!$this->EngineNumber->Raw) {
            $this->EngineNumber->CurrentValue = HtmlDecode($this->EngineNumber->CurrentValue);
        }
        $this->EngineNumber->EditValue = $this->EngineNumber->CurrentValue;
        $this->EngineNumber->PlaceHolder = RemoveHtml($this->EngineNumber->caption());

        // Chasis Number
        $this->ChasisNumber->EditAttrs["class"] = "form-control";
        $this->ChasisNumber->EditCustomAttributes = "";
        if (!$this->ChasisNumber->Raw) {
            $this->ChasisNumber->CurrentValue = HtmlDecode($this->ChasisNumber->CurrentValue);
        }
        $this->ChasisNumber->EditValue = $this->ChasisNumber->CurrentValue;
        $this->ChasisNumber->PlaceHolder = RemoveHtml($this->ChasisNumber->caption());

        // Civilian Plate Number
        $this->CivilianPlateNumber->EditAttrs["class"] = "form-control";
        $this->CivilianPlateNumber->EditCustomAttributes = "";
        if (!$this->CivilianPlateNumber->Raw) {
            $this->CivilianPlateNumber->CurrentValue = HtmlDecode($this->CivilianPlateNumber->CurrentValue);
        }
        $this->CivilianPlateNumber->EditValue = $this->CivilianPlateNumber->CurrentValue;
        $this->CivilianPlateNumber->PlaceHolder = RemoveHtml($this->CivilianPlateNumber->caption());

        // Govt Plate Number
        $this->GovtPlateNumber->EditAttrs["class"] = "form-control";
        $this->GovtPlateNumber->EditCustomAttributes = "";
        if (!$this->GovtPlateNumber->Raw) {
            $this->GovtPlateNumber->CurrentValue = HtmlDecode($this->GovtPlateNumber->CurrentValue);
        }
        $this->GovtPlateNumber->EditValue = $this->GovtPlateNumber->CurrentValue;
        $this->GovtPlateNumber->PlaceHolder = RemoveHtml($this->GovtPlateNumber->caption());

        // Asset_No
        $this->Asset_No->EditAttrs["class"] = "form-control";
        $this->Asset_No->EditCustomAttributes = "";
        if (!$this->Asset_No->Raw) {
            $this->Asset_No->CurrentValue = HtmlDecode($this->Asset_No->CurrentValue);
        }
        $this->Asset_No->EditValue = $this->Asset_No->CurrentValue;
        $this->Asset_No->PlaceHolder = RemoveHtml($this->Asset_No->caption());

        // Details_of_Asset
        $this->Details_of_Asset->EditAttrs["class"] = "form-control";
        $this->Details_of_Asset->EditCustomAttributes = "";
        if (!$this->Details_of_Asset->Raw) {
            $this->Details_of_Asset->CurrentValue = HtmlDecode($this->Details_of_Asset->CurrentValue);
        }
        $this->Details_of_Asset->EditValue = $this->Details_of_Asset->CurrentValue;
        $this->Details_of_Asset->PlaceHolder = RemoveHtml($this->Details_of_Asset->caption());

        // Condition_Of_Asset
        $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
        $this->Condition_Of_Asset->EditCustomAttributes = "";
        $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

        // Custodian_id
        $this->Custodian_id->EditAttrs["class"] = "form-control";
        $this->Custodian_id->EditCustomAttributes = "";
        $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

        // Category
        $this->Category->EditCustomAttributes = "";
        $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

        // Category_Details
        $this->Category_Details->EditAttrs["class"] = "form-control";
        $this->Category_Details->EditCustomAttributes = "";
        $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

        // Date_of_Acquisition
        $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
        $this->Date_of_Acquisition->EditCustomAttributes = "";
        $this->Date_of_Acquisition->EditValue = FormatDateTime($this->Date_of_Acquisition->CurrentValue, 8);
        $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

        // Aquistion_Cost
        $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
        $this->Aquistion_Cost->EditCustomAttributes = "";
        $this->Aquistion_Cost->EditValue = $this->Aquistion_Cost->CurrentValue;
        $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());
        if (strval($this->Aquistion_Cost->EditValue) != "" && is_numeric($this->Aquistion_Cost->EditValue)) {
            $this->Aquistion_Cost->EditValue = FormatNumber($this->Aquistion_Cost->EditValue, -2, -2, -2, -2);
        }

        // Additional_Cost
        $this->Additional_Cost->EditAttrs["class"] = "form-control";
        $this->Additional_Cost->EditCustomAttributes = "";
        $this->Additional_Cost->EditValue = $this->Additional_Cost->CurrentValue;
        $this->Additional_Cost->PlaceHolder = RemoveHtml($this->Additional_Cost->caption());
        if (strval($this->Additional_Cost->EditValue) != "" && is_numeric($this->Additional_Cost->EditValue)) {
            $this->Additional_Cost->EditValue = FormatNumber($this->Additional_Cost->EditValue, -2, -2, -2, -2);
        }

        // Revaluation_Cost
        $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
        $this->Revaluation_Cost->EditCustomAttributes = "";
        $this->Revaluation_Cost->EditValue = $this->Revaluation_Cost->CurrentValue;
        $this->Revaluation_Cost->PlaceHolder = RemoveHtml($this->Revaluation_Cost->caption());
        if (strval($this->Revaluation_Cost->EditValue) != "" && is_numeric($this->Revaluation_Cost->EditValue)) {
            $this->Revaluation_Cost->EditValue = FormatNumber($this->Revaluation_Cost->EditValue, -2, -2, -2, -2);
        }

        // Remarks
        $this->Remarks->EditAttrs["class"] = "form-control";
        $this->Remarks->EditCustomAttributes = "";
        $this->Remarks->EditValue = $this->Remarks->CurrentValue;
        $this->Remarks->PlaceHolder = RemoveHtml($this->Remarks->caption());

        // Created_on

        // Updated_on

        // Created_By
        $this->Created_By->EditAttrs["class"] = "form-control";
        $this->Created_By->EditCustomAttributes = "";
        $this->Created_By->EditValue = $this->Created_By->CurrentValue;
        $this->Created_By->PlaceHolder = RemoveHtml($this->Created_By->caption());

        // MDA_temp
        $this->MDA_temp->EditAttrs["class"] = "form-control";
        $this->MDA_temp->EditCustomAttributes = "";
        if (!$this->MDA_temp->Raw) {
            $this->MDA_temp->CurrentValue = HtmlDecode($this->MDA_temp->CurrentValue);
        }
        $this->MDA_temp->EditValue = $this->MDA_temp->CurrentValue;
        $this->MDA_temp->PlaceHolder = RemoveHtml($this->MDA_temp->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->Aquistion_Cost->CurrentValue)) {
                $this->Aquistion_Cost->Total += $this->Aquistion_Cost->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->Additional_Cost->CurrentValue)) {
                $this->Additional_Cost->Total += $this->Additional_Cost->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->Revaluation_Cost->CurrentValue)) {
                $this->Revaluation_Cost->Total += $this->Revaluation_Cost->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->Aquistion_Cost->CurrentValue = $this->Aquistion_Cost->Total;
            $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -1, -2);
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = ""; // Clear href value
            $this->Additional_Cost->CurrentValue = $this->Additional_Cost->Total;
            $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";
            $this->Additional_Cost->HrefValue = ""; // Clear href value
            $this->Revaluation_Cost->CurrentValue = $this->Revaluation_Cost->Total;
            $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->MDA_Parent);
                    $doc->exportCaption($this->Location_id);
                    $doc->exportCaption($this->Asset_Status);
                    $doc->exportCaption($this->Category_Temp);
                    $doc->exportCaption($this->Make);
                    $doc->exportCaption($this->Model);
                    $doc->exportCaption($this->YearofManufacture);
                    $doc->exportCaption($this->Colour);
                    $doc->exportCaption($this->EngineNumber);
                    $doc->exportCaption($this->ChasisNumber);
                    $doc->exportCaption($this->CivilianPlateNumber);
                    $doc->exportCaption($this->GovtPlateNumber);
                    $doc->exportCaption($this->Asset_No);
                    $doc->exportCaption($this->Details_of_Asset);
                    $doc->exportCaption($this->Condition_Of_Asset);
                    $doc->exportCaption($this->Custodian_id);
                    $doc->exportCaption($this->Category_Details);
                    $doc->exportCaption($this->Date_of_Acquisition);
                    $doc->exportCaption($this->Aquistion_Cost);
                    $doc->exportCaption($this->Additional_Cost);
                    $doc->exportCaption($this->Revaluation_Cost);
                    $doc->exportCaption($this->Remarks);
                } else {
                    $doc->exportCaption($this->Assetsid);
                    $doc->exportCaption($this->MDA_Parent);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->Location_id);
                    $doc->exportCaption($this->Asset_Status);
                    $doc->exportCaption($this->Details_of_Asset);
                    $doc->exportCaption($this->Condition_Of_Asset);
                    $doc->exportCaption($this->Custodian_id);
                    $doc->exportCaption($this->Category_Details);
                    $doc->exportCaption($this->Date_of_Acquisition);
                    $doc->exportCaption($this->Aquistion_Cost);
                    $doc->exportCaption($this->Additional_Cost);
                    $doc->exportCaption($this->Revaluation_Cost);
                    $doc->exportCaption($this->Remarks);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->MDA_Parent);
                        $doc->exportField($this->Location_id);
                        $doc->exportField($this->Asset_Status);
                        $doc->exportField($this->Category_Temp);
                        $doc->exportField($this->Make);
                        $doc->exportField($this->Model);
                        $doc->exportField($this->YearofManufacture);
                        $doc->exportField($this->Colour);
                        $doc->exportField($this->EngineNumber);
                        $doc->exportField($this->ChasisNumber);
                        $doc->exportField($this->CivilianPlateNumber);
                        $doc->exportField($this->GovtPlateNumber);
                        $doc->exportField($this->Asset_No);
                        $doc->exportField($this->Details_of_Asset);
                        $doc->exportField($this->Condition_Of_Asset);
                        $doc->exportField($this->Custodian_id);
                        $doc->exportField($this->Category_Details);
                        $doc->exportField($this->Date_of_Acquisition);
                        $doc->exportField($this->Aquistion_Cost);
                        $doc->exportField($this->Additional_Cost);
                        $doc->exportField($this->Revaluation_Cost);
                        $doc->exportField($this->Remarks);
                    } else {
                        $doc->exportField($this->Assetsid);
                        $doc->exportField($this->MDA_Parent);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->Location_id);
                        $doc->exportField($this->Asset_Status);
                        $doc->exportField($this->Details_of_Asset);
                        $doc->exportField($this->Condition_Of_Asset);
                        $doc->exportField($this->Custodian_id);
                        $doc->exportField($this->Category_Details);
                        $doc->exportField($this->Date_of_Acquisition);
                        $doc->exportField($this->Aquistion_Cost);
                        $doc->exportField($this->Additional_Cost);
                        $doc->exportField($this->Revaluation_Cost);
                        $doc->exportField($this->Remarks);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = ROWTYPE_AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->Assetsid, '');
                $doc->exportAggregate($this->MDA_Parent, '');
                $doc->exportAggregate($this->MDA_id, '');
                $doc->exportAggregate($this->Location_id, '');
                $doc->exportAggregate($this->Asset_Status, '');
                $doc->exportAggregate($this->Details_of_Asset, '');
                $doc->exportAggregate($this->Condition_Of_Asset, '');
                $doc->exportAggregate($this->Custodian_id, '');
                $doc->exportAggregate($this->Category_Details, '');
                $doc->exportAggregate($this->Date_of_Acquisition, '');
                $doc->exportAggregate($this->Aquistion_Cost, 'TOTAL');
                $doc->exportAggregate($this->Additional_Cost, 'TOTAL');
                $doc->exportAggregate($this->Revaluation_Cost, 'TOTAL');
                $doc->exportAggregate($this->Remarks, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add User ID filter
    public function addUserIDFilter($filter = "")
    {
        global $Security;
        $filterWrk = "";
        $id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
        if (!$this->userIDAllow($id) && !$Security->isAdmin()) {
            $filterWrk = $Security->userIdList();
            if ($filterWrk != "") {
                $filterWrk = '`MDA_id` IN (' . $filterWrk . ')';
            }
        }

        // Call User ID Filtering event
        $this->userIdFiltering($filterWrk);
        AddFilter($filter, $filterWrk);
        return $filter;
    }

    // User ID subquery
    public function getUserIDSubquery(&$fld, &$masterfld)
    {
        global $UserTable;
        $wrk = "";
        $sql = "SELECT " . $masterfld->Expression . " FROM `assetstbl`";
        $filter = $this->addUserIDFilter("");
        if ($filter != "") {
            $sql .= " WHERE " . $filter;
        }

        // List all values
        if ($rs = Conn($UserTable->Dbid)->executeQuery($sql)->fetchAll(\PDO::FETCH_NUM)) {
            foreach ($rs as $row) {
                if ($wrk != "") {
                    $wrk .= ",";
                }
                $wrk .= QuotedValue($row[0], $masterfld->DataType, Config("USER_TABLE_DBID"));
            }
        }
        if ($wrk != "") {
            $wrk = $fld->Expression . " IN (" . $wrk . ")";
        } else { // No User ID value found
            $wrk = "0=1";
        }
        return $wrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Write Audit Trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        $table = 'assetstbl';
        $usr = CurrentUserID();
        WriteAuditLog($usr, $typ, $table, "", "", "", "");
    }

    // Write Audit Trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }
        $table = 'assetstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['Assetsid'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $newvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $newvalue = $rs[$fldname];
                    } else {
                        $newvalue = "[MEMO]"; // Memo Field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $newvalue = "[XML]"; // XML Field
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", $table, $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write Audit Trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }
        $table = 'assetstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['Assetsid'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                        if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                            $oldvalue = $rsold[$fldname];
                            $newvalue = $rsnew[$fldname];
                        } else {
                            $oldvalue = "[MEMO]";
                            $newvalue = "[MEMO]";
                        }
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write Audit Trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }
        $table = 'assetstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['Assetsid'];

        // Write Audit Trail
        $curUser = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $oldvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $oldvalue = $rs[$fldname];
                    } else {
                        $oldvalue = "[MEMO]"; // Memo field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $oldvalue = "[XML]"; // XML field
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($curUser, "D", $table, $fldname, $key, $oldvalue, "");
            }
        }
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
       /*
            $Category1='';
            $Category2='';
            // Enter your code here
            // die($filter); // Uncomment to view the filter first
            // get search values
            $flt_date_begin = $this->Year_of_Aquistion->AdvancedSearch->SearchValue;
    $flt_date_end = $this->Year_of_Aquistion->AdvancedSearch->SearchValue2;
           $Location= $this->Location->AdvancedSearch->SearchValue;
           $MDA_id= $this->MDA_id->AdvancedSearch->SearchValue;
           $Category= $this->Category->AdvancedSearch->SearchValue; //x_Category[]
           if($Category == 1){
        $Category1 ='Movable';
           }
           if($Category == 2){
        $Category2 ='IMovable';
           }
           // Get a field value
    // NOTE: Modify your SQL here, replace the table name, field name and the condition
    $myField = ExecuteScalar("SELECT MDA_Acronym FROM mdatbl WHERE MDAID = '$MDA_id'");
    $MDA_id =$myField;
          // var_dump($Location,$MDA_id,$Category1,$Category2);
          echo $Location ; echo '<br>'; echo $MDA_id; echo '<br>';echo $Category1; echo '<br>';echo $Category2; echo '<br>'; echo $flt_date_begin ; echo '<br>'; echo $flt_date_end;
    */
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
        public function rowInserting($rsold, &$rsnew)
        {
            // Enter your code here
            // To cancel, set return value to false

             // set condition in variable
        $condition  = $rsnew["Category_Temp"] ; 
            // Get a field value
        $myField = ExecuteScalar("SELECT Category_id FROM categorydetailstbl WHERE Category_Details = '$condition'");
        $rsnew["Category"] =$myField ;
        $rsnew["Category_Details"]=$condition ;

    /*
        $username= CurrentUsername();

        //get userid
    $myRow = ExecuteRow("SELECT userid  ,Lastname,Firstname FROM reportuserstbl WHERE Username  = '$username'");
     $userid = $myRow["userid"];
     $Lastname = $myRow["Lastname"];
     $Firstname = $myRow["Firstname"];
    $rsnew["Created_By"]=$userid ;

        //get username
     $rsnew["user_id"] =$userid ;
     $rsnew["Lastname"] =$Lastname ;
     $rsnew["Firstname"] =$Firstname ;

    // insert all remarks on allremarkstbl
        $allrmk=$rsnew["Asset_No"]  ;
        $allrmk1 =  $rsnew["Details_of_Asset"] ;
        $allrmk2 =$rsnew["MDA_id"]  ;
        $allrmk3 =$rsnew["Remarks"]  ;
        $allrmk4  =$rsnew["user_id"]  ;
         $allrmk5  = $rsnew["Lastname"]  ;
          $allrmk6  =$rsnew["Firstname"]  ;
        $myResult = ExecuteUpdate("INSERT INTO  allremarkstbl (Asset_No,Details_of_Asset, MDA_id,user_id,Lastname,Firstname, Remark) VALUES ('$allrmk', '$allrmk1', '$allrmk2','$allrmk4','$allrmk5','$allrmk6', '$allrmk3')");
      */
            return true;
        }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
       ExecuteUpdate('SET SQL_WARNINGS=1');
     // Get userid. Ignoring Default user function. This is secured !
        // I did this coz MDA_id was use as fliter for all users'
        $username= CurrentUsername();
        $myRow = ExecuteRow("SELECT userid FROM reportuserstbl WHERE Username  = '$username'");
         $userid = $myRow["userid"];
    // force id to INT
            $INTuserid = (int)$userid;

         //$rsnew["user_id"] =$userid ;

        // Set fileds to variable    
        $Assetid=$rsnew["Assetsid"];
        $AssetNo=$rsnew["Asset_No"];
        $Details_of_Asset=$rsnew["Details_of_Asset"];
        $Asset_Status=$rsnew["Asset_Status"];
        $Condition_Of_Asset=$rsnew["Condition_Of_Asset"];
        $Location_id=$rsnew["Location_id"];
        $MDA_id=$rsnew["MDA_id"];
        $Category=$rsnew["Category"];
        $Category_Details=$rsnew["Category_Temp"];
        $Make=$rsnew["Make"];
         $INTMake = (int)$Make;
        $Model=$rsnew["Model"];
        $INTModel = (int)$Model;
        $YearofManufacture=$rsnew["Year of Manufacture"];
        //force year to INT
        $INTYearofManufacture = (int)$YearofManufacture;
        $Colour=$rsnew["Colour"];
        $EngineNumber=$rsnew["Engine Number"];
        $ChasisNumber=$rsnew["Chasis Number"];
        $CivilianPlateNumber=$rsnew["Civilian Plate Number"];
        $GovtPlateNumber=$rsnew["Govt Plate Number"];
        $Custodian_id=$rsnew["Custodian_id"];
        $Date_of_Acquisition=$rsnew["Date_of_Acquisition"];
        $Aquistion_Cost=$rsnew["Aquistion_Cost"];
        $Additional_Cost=$rsnew["Additional_Cost"];
        $Revaluation_Cost=$rsnew["Revaluation_Cost"];
        $Remarks=$rsnew["Remarks"];

        // convert costs to float
        $floatAquistion_Cost = (float)$Aquistion_Cost;
        $floatAdditional_Cost = (float)$Additional_Cost;
        $floatRevaluation_Cost = (float)$Revaluation_Cost;

         // insert into assettbl log. (Audit Trail)

        // Insert record
        // NOTE: Modify your SQL here, replace the table name, field name and field values
        $assetslog = ExecuteUpdate("INSERT INTO assetsaudittrailtbl (Asset_id,Asset_No,Details_of_Asset,Asset_Status,Condition_Of_Asset, Location_id,MDA_id,Category,Category_Details,Make,Model,`Year of Manufacture`,`Colour`,`Engine Number`,`Chasis Number`,`Civilian Plate Number`, `Govt Plate Number`,Custodian_id,Date_of_Acquisition,Aquistion_Cost,Additional_Cost,Revaluation_Cost,Remarks,Created_By)
        VALUES ('$Assetid', '$AssetNo', '$Details_of_Asset','$Asset_Status','$Condition_Of_Asset','$Location_id','$MDA_id',
        '$Category','$Category_Details','$INTMake','$INTModel','$INTYearofManufacture','$Colour','$EngineNumber','$ChasisNumber',
        '$CivilianPlateNumber','$GovtPlateNumber','$Custodian_id','$Date_of_Acquisition','$floatAquistion_Cost','$floatAdditional_Cost','$floatRevaluation_Cost','$Remarks','$INT$userid')");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
         // Enter your code here
        // To cancel, set return value to false
         // set condition in variable
    $condition  = $rsnew["Category_Temp"] ; 
        // Get a field value
    $myField = ExecuteScalar("SELECT Category_id FROM categorydetailstbl WHERE Category_Details = '$condition'");
    $rsnew["Category"] =$myField ;
    $rsnew["Category_Details"]=$condition ;

    /*
    //get username
        $username= CurrentUsername();

        //get userid
       // $myField2 = ExecuteScalar("SELECT userid  ,Lastname,Firstname FROM reportuserstbl WHERE Username  = '$username'");
        //$rsnew["user_id"] =$myField2 ;

    // Get a record as associative array
    // NOTE: Modify your SQL here, replace the table name, field name and the condition
    $myRow = ExecuteRow("SELECT userid  ,Lastname,Firstname FROM reportuserstbl WHERE Username  = '$username'");
     $userid = $myRow["userid"];
     $Lastname = $myRow["Lastname"];
     $Firstname = $myRow["Firstname"];
     $rsnew["user_id"] =$userid ;
     $rsnew["Lastname"] =$Lastname ;
     $rsnew["Firstname"] =$Firstname ;

    // insert all remarks on allremarkstbl
        $allrmk=$rsnew["Asset_No"]  ;
        $allrmk1 =  $rsnew["Details_of_Asset"] ;
        $allrmk2 =$rsnew["MDA_id"]  ;
        $allrmk3 =$rsnew["Remarks"]  ;
        $allrmk4  =$rsnew["user_id"]  ;
         $allrmk5  = $rsnew["Lastname"]  ;
          $allrmk6  =$rsnew["Firstname"]  ;
        $myResult = ExecuteUpdate("INSERT INTO  allremarkstbl (Asset_No,Details_of_Asset, MDA_id,user_id,Lastname,Firstname, Remark) VALUES ('$allrmk', '$allrmk1', '$allrmk2','$allrmk4','$allrmk5','$allrmk6', '$allrmk3')");
    */
            return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
      // Get userid. Ignoring Default user function. This is secured !
        // I did this coz MDA_id was use as fliter for all users'
        $username= CurrentUsername();
        $vintogetisuerid = ExecuteRow("SELECT userid FROM reportuserstbl WHERE Username  = '$username'");
         $userid = $vintogetisuerid["userid"];
         // force id to INT
            $INTuserid = (int)$userid;

         //$rsnew["user_id"] =$userid ;

        // Set fileds to variable    
        $Assetid=$rsold["Assetsid"];
        $AssetNo=$rsnew["Asset_No"];
        $Details_of_Asset=$rsnew["Details_of_Asset"];
        $Asset_Status=$rsnew["Asset_Status"];
        $Condition_Of_Asset=$rsnew["Condition_Of_Asset"];
        $Location_id=$rsnew["Location_id"];
        $MDA_id=$rsnew["MDA_id"];
        $Category=$rsnew["Category"];
        $Category_Details=$rsnew["Category_Temp"];
        $Make=$rsnew["Make"];
        $INTMake = (int)$Make;
        $Model=$rsnew["Model"];
         $INTModel = (int)$Model;
        $YearofManufacture=$rsnew["Year of Manufacture"];
        //force year to INT
        $INTYearofManufacture = (int)$YearofManufacture;
        $Colour=$rsnew["Colour"];
        $EngineNumber=$rsnew["Engine Number"];
        $ChasisNumber=$rsnew["Chasis Number"];
        $CivilianPlateNumber=$rsnew["Civilian Plate Number"];
        $GovtPlateNumber=$rsnew["Govt Plate Number"];
        $Custodian_id=$rsnew["Custodian_id"];
        $Date_of_Acquisition=$rsnew["Date_of_Acquisition"];
        $Aquistion_Cost=$rsnew["Aquistion_Cost"];
        $Additional_Cost=$rsnew["Additional_Cost"];
        $Revaluation_Cost=$rsnew["Revaluation_Cost"];
        $Remarks=$rsnew["Remarks"];

        // convert costs to float
        $floatAquistion_Cost = (float)$Aquistion_Cost;
        $floatAdditional_Cost = (float)$Additional_Cost;
        $floatRevaluation_Cost = (float)$Revaluation_Cost;

         // insert into assettbl log. (Audit Trail)

        // Insert record
        // NOTE: Modify your SQL here, replace the table name, field name and field values
        $assetslog = ExecuteUpdate("INSERT INTO assetsaudittrailtbl (Asset_id,Asset_No,Details_of_Asset,Asset_Status,Condition_Of_Asset, Location_id,MDA_id,Category,Category_Details,Make,Model,`Year of Manufacture`,`Colour`,`Engine Number`,`Chasis Number`,`Civilian Plate Number`, `Govt Plate Number`,Custodian_id,Date_of_Acquisition,Aquistion_Cost,Additional_Cost,Revaluation_Cost,Remarks,Created_By)
        VALUES ('$Assetid', '$AssetNo', '$Details_of_Asset','$Asset_Status','$Condition_Of_Asset','$Location_id','$MDA_id',
        '$Category','$Category_Details','$INTMake','$INTModel','$INTYearofManufacture','$Colour','$EngineNumber','$ChasisNumber',
        '$CivilianPlateNumber','$GovtPlateNumber','$Custodian_id','$Date_of_Acquisition','$floatAquistion_Cost','$floatAdditional_Cost','$floatRevaluation_Cost','$Remarks','$INT$userid')");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
