<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class AssetstblEdit extends Assetstbl
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'assetstbl';

    // Page object name
    public $PageObjName = "AssetstblEdit";

    // Rendering View
    public $RenderingView = false;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (assetstbl)
        if (!isset($GLOBALS["assetstbl"]) || get_class($GLOBALS["assetstbl"]) == PROJECT_NAMESPACE . "assetstbl") {
            $GLOBALS["assetstbl"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'assetstbl');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("assetstbl"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $row = ["url" => GetUrl($url), "modal" => "1"];
                $pageName = GetPageName($url);
                if ($pageName != $this->getListUrl()) { // Not List page
                    $row["caption"] = $this->getModalCaption($pageName);
                    if ($pageName == "assetstblview") {
                        $row["view"] = "1";
                    }
                } else { // List page should not be shown as modal => error
                    $row["error"] = $this->getFailureMessage();
                    $this->clearFailureMessage();
                }
                WriteJson($row);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['Assetsid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->Assetsid->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }
    public $FormClassName = "ew-horizontal ew-form ew-edit-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
            $SkipHeaderFooter;

        // Is modal
        $this->IsModal = Param("modal") == "1";

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->Assetsid->Visible = false;
        $this->MDA_Parent->setVisibility();
        $this->MDA_id->setVisibility();
        $this->Location_id->setVisibility();
        $this->Asset_Status->setVisibility();
        $this->Category_Temp->setVisibility();
        $this->Make->setVisibility();
        $this->Model->setVisibility();
        $this->YearofManufacture->setVisibility();
        $this->Colour->setVisibility();
        $this->EngineNumber->setVisibility();
        $this->ChasisNumber->setVisibility();
        $this->CivilianPlateNumber->setVisibility();
        $this->GovtPlateNumber->setVisibility();
        $this->Asset_No->setVisibility();
        $this->Details_of_Asset->setVisibility();
        $this->Condition_Of_Asset->setVisibility();
        $this->Custodian_id->setVisibility();
        $this->Category->Visible = false;
        $this->Category_Details->Visible = false;
        $this->Date_of_Acquisition->setVisibility();
        $this->Aquistion_Cost->setVisibility();
        $this->Additional_Cost->setVisibility();
        $this->Revaluation_Cost->setVisibility();
        $this->Remarks->setVisibility();
        $this->Created_on->Visible = false;
        $this->Updated_on->setVisibility();
        $this->Created_By->Visible = false;
        $this->MDA_temp->Visible = false;
        $this->hideFieldsForAddEdit();

        // Do not use lookup cache
        $this->setUseLookupCache(false);

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->MDA_Parent);
        $this->setupLookupOptions($this->MDA_id);
        $this->setupLookupOptions($this->Location_id);
        $this->setupLookupOptions($this->Asset_Status);
        $this->setupLookupOptions($this->Category_Temp);
        $this->setupLookupOptions($this->Make);
        $this->setupLookupOptions($this->Model);
        $this->setupLookupOptions($this->Condition_Of_Asset);
        $this->setupLookupOptions($this->Custodian_id);
        $this->setupLookupOptions($this->Category);
        $this->setupLookupOptions($this->Category_Details);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $this->FormClassName = "ew-form ew-edit-form ew-horizontal";
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("Assetsid") ?? Key(0) ?? Route(2)) !== null) {
                $this->Assetsid->setQueryStringValue($keyValue);
                $this->Assetsid->setOldValue($this->Assetsid->QueryStringValue);
            } elseif (Post("Assetsid") !== null) {
                $this->Assetsid->setFormValue(Post("Assetsid"));
                $this->Assetsid->setOldValue($this->Assetsid->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action") !== null) {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("Assetsid") ?? Route("Assetsid")) !== null) {
                    $this->Assetsid->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->Assetsid->CurrentValue = null;
                }
            }

            // Load recordset
            if ($this->isShow()) {
                // Load current record
                $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$loaded) { // Load record based on key
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("assetstbllist"); // No matching record, return to list
                    return;
                }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "assetstbllist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }
                    if (IsApi()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = ROWTYPE_EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'MDA_Parent' first before field var 'x_MDA_Parent'
        $val = $CurrentForm->hasValue("MDA_Parent") ? $CurrentForm->getValue("MDA_Parent") : $CurrentForm->getValue("x_MDA_Parent");
        if (!$this->MDA_Parent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MDA_Parent->Visible = false; // Disable update for API request
            } else {
                $this->MDA_Parent->setFormValue($val);
            }
        }

        // Check field name 'MDA_id' first before field var 'x_MDA_id'
        $val = $CurrentForm->hasValue("MDA_id") ? $CurrentForm->getValue("MDA_id") : $CurrentForm->getValue("x_MDA_id");
        if (!$this->MDA_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MDA_id->Visible = false; // Disable update for API request
            } else {
                $this->MDA_id->setFormValue($val);
            }
        }

        // Check field name 'Location_id' first before field var 'x_Location_id'
        $val = $CurrentForm->hasValue("Location_id") ? $CurrentForm->getValue("Location_id") : $CurrentForm->getValue("x_Location_id");
        if (!$this->Location_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Location_id->Visible = false; // Disable update for API request
            } else {
                $this->Location_id->setFormValue($val);
            }
        }

        // Check field name 'Asset_Status' first before field var 'x_Asset_Status'
        $val = $CurrentForm->hasValue("Asset_Status") ? $CurrentForm->getValue("Asset_Status") : $CurrentForm->getValue("x_Asset_Status");
        if (!$this->Asset_Status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Asset_Status->Visible = false; // Disable update for API request
            } else {
                $this->Asset_Status->setFormValue($val);
            }
        }

        // Check field name 'Category_Temp' first before field var 'x_Category_Temp'
        $val = $CurrentForm->hasValue("Category_Temp") ? $CurrentForm->getValue("Category_Temp") : $CurrentForm->getValue("x_Category_Temp");
        if (!$this->Category_Temp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Category_Temp->Visible = false; // Disable update for API request
            } else {
                $this->Category_Temp->setFormValue($val);
            }
        }

        // Check field name 'Make' first before field var 'x_Make'
        $val = $CurrentForm->hasValue("Make") ? $CurrentForm->getValue("Make") : $CurrentForm->getValue("x_Make");
        if (!$this->Make->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Make->Visible = false; // Disable update for API request
            } else {
                $this->Make->setFormValue($val);
            }
        }

        // Check field name 'Model' first before field var 'x_Model'
        $val = $CurrentForm->hasValue("Model") ? $CurrentForm->getValue("Model") : $CurrentForm->getValue("x_Model");
        if (!$this->Model->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Model->Visible = false; // Disable update for API request
            } else {
                $this->Model->setFormValue($val);
            }
        }

        // Check field name 'Year of Manufacture' first before field var 'x_YearofManufacture'
        $val = $CurrentForm->hasValue("Year of Manufacture") ? $CurrentForm->getValue("Year of Manufacture") : $CurrentForm->getValue("x_YearofManufacture");
        if (!$this->YearofManufacture->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->YearofManufacture->Visible = false; // Disable update for API request
            } else {
                $this->YearofManufacture->setFormValue($val);
            }
        }

        // Check field name 'Colour' first before field var 'x_Colour'
        $val = $CurrentForm->hasValue("Colour") ? $CurrentForm->getValue("Colour") : $CurrentForm->getValue("x_Colour");
        if (!$this->Colour->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Colour->Visible = false; // Disable update for API request
            } else {
                $this->Colour->setFormValue($val);
            }
        }

        // Check field name 'Engine Number' first before field var 'x_EngineNumber'
        $val = $CurrentForm->hasValue("Engine Number") ? $CurrentForm->getValue("Engine Number") : $CurrentForm->getValue("x_EngineNumber");
        if (!$this->EngineNumber->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->EngineNumber->Visible = false; // Disable update for API request
            } else {
                $this->EngineNumber->setFormValue($val);
            }
        }

        // Check field name 'Chasis Number' first before field var 'x_ChasisNumber'
        $val = $CurrentForm->hasValue("Chasis Number") ? $CurrentForm->getValue("Chasis Number") : $CurrentForm->getValue("x_ChasisNumber");
        if (!$this->ChasisNumber->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ChasisNumber->Visible = false; // Disable update for API request
            } else {
                $this->ChasisNumber->setFormValue($val);
            }
        }

        // Check field name 'Civilian Plate Number' first before field var 'x_CivilianPlateNumber'
        $val = $CurrentForm->hasValue("Civilian Plate Number") ? $CurrentForm->getValue("Civilian Plate Number") : $CurrentForm->getValue("x_CivilianPlateNumber");
        if (!$this->CivilianPlateNumber->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CivilianPlateNumber->Visible = false; // Disable update for API request
            } else {
                $this->CivilianPlateNumber->setFormValue($val);
            }
        }

        // Check field name 'Govt Plate Number' first before field var 'x_GovtPlateNumber'
        $val = $CurrentForm->hasValue("Govt Plate Number") ? $CurrentForm->getValue("Govt Plate Number") : $CurrentForm->getValue("x_GovtPlateNumber");
        if (!$this->GovtPlateNumber->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GovtPlateNumber->Visible = false; // Disable update for API request
            } else {
                $this->GovtPlateNumber->setFormValue($val);
            }
        }

        // Check field name 'Asset_No' first before field var 'x_Asset_No'
        $val = $CurrentForm->hasValue("Asset_No") ? $CurrentForm->getValue("Asset_No") : $CurrentForm->getValue("x_Asset_No");
        if (!$this->Asset_No->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Asset_No->Visible = false; // Disable update for API request
            } else {
                $this->Asset_No->setFormValue($val);
            }
        }

        // Check field name 'Details_of_Asset' first before field var 'x_Details_of_Asset'
        $val = $CurrentForm->hasValue("Details_of_Asset") ? $CurrentForm->getValue("Details_of_Asset") : $CurrentForm->getValue("x_Details_of_Asset");
        if (!$this->Details_of_Asset->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Details_of_Asset->Visible = false; // Disable update for API request
            } else {
                $this->Details_of_Asset->setFormValue($val);
            }
        }

        // Check field name 'Condition_Of_Asset' first before field var 'x_Condition_Of_Asset'
        $val = $CurrentForm->hasValue("Condition_Of_Asset") ? $CurrentForm->getValue("Condition_Of_Asset") : $CurrentForm->getValue("x_Condition_Of_Asset");
        if (!$this->Condition_Of_Asset->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Condition_Of_Asset->Visible = false; // Disable update for API request
            } else {
                $this->Condition_Of_Asset->setFormValue($val);
            }
        }

        // Check field name 'Custodian_id' first before field var 'x_Custodian_id'
        $val = $CurrentForm->hasValue("Custodian_id") ? $CurrentForm->getValue("Custodian_id") : $CurrentForm->getValue("x_Custodian_id");
        if (!$this->Custodian_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Custodian_id->Visible = false; // Disable update for API request
            } else {
                $this->Custodian_id->setFormValue($val);
            }
        }

        // Check field name 'Date_of_Acquisition' first before field var 'x_Date_of_Acquisition'
        $val = $CurrentForm->hasValue("Date_of_Acquisition") ? $CurrentForm->getValue("Date_of_Acquisition") : $CurrentForm->getValue("x_Date_of_Acquisition");
        if (!$this->Date_of_Acquisition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Date_of_Acquisition->Visible = false; // Disable update for API request
            } else {
                $this->Date_of_Acquisition->setFormValue($val);
            }
            $this->Date_of_Acquisition->CurrentValue = UnFormatDateTime($this->Date_of_Acquisition->CurrentValue, 0);
        }

        // Check field name 'Aquistion_Cost' first before field var 'x_Aquistion_Cost'
        $val = $CurrentForm->hasValue("Aquistion_Cost") ? $CurrentForm->getValue("Aquistion_Cost") : $CurrentForm->getValue("x_Aquistion_Cost");
        if (!$this->Aquistion_Cost->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Aquistion_Cost->Visible = false; // Disable update for API request
            } else {
                $this->Aquistion_Cost->setFormValue($val);
            }
        }

        // Check field name 'Additional_Cost' first before field var 'x_Additional_Cost'
        $val = $CurrentForm->hasValue("Additional_Cost") ? $CurrentForm->getValue("Additional_Cost") : $CurrentForm->getValue("x_Additional_Cost");
        if (!$this->Additional_Cost->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Additional_Cost->Visible = false; // Disable update for API request
            } else {
                $this->Additional_Cost->setFormValue($val);
            }
        }

        // Check field name 'Revaluation_Cost' first before field var 'x_Revaluation_Cost'
        $val = $CurrentForm->hasValue("Revaluation_Cost") ? $CurrentForm->getValue("Revaluation_Cost") : $CurrentForm->getValue("x_Revaluation_Cost");
        if (!$this->Revaluation_Cost->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Revaluation_Cost->Visible = false; // Disable update for API request
            } else {
                $this->Revaluation_Cost->setFormValue($val);
            }
        }

        // Check field name 'Remarks' first before field var 'x_Remarks'
        $val = $CurrentForm->hasValue("Remarks") ? $CurrentForm->getValue("Remarks") : $CurrentForm->getValue("x_Remarks");
        if (!$this->Remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Remarks->Visible = false; // Disable update for API request
            } else {
                $this->Remarks->setFormValue($val);
            }
        }

        // Check field name 'Updated_on' first before field var 'x_Updated_on'
        $val = $CurrentForm->hasValue("Updated_on") ? $CurrentForm->getValue("Updated_on") : $CurrentForm->getValue("x_Updated_on");
        if (!$this->Updated_on->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Updated_on->Visible = false; // Disable update for API request
            } else {
                $this->Updated_on->setFormValue($val);
            }
            $this->Updated_on->CurrentValue = UnFormatDateTime($this->Updated_on->CurrentValue, 0);
        }

        // Check field name 'Assetsid' first before field var 'x_Assetsid'
        $val = $CurrentForm->hasValue("Assetsid") ? $CurrentForm->getValue("Assetsid") : $CurrentForm->getValue("x_Assetsid");
        if (!$this->Assetsid->IsDetailKey) {
            $this->Assetsid->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->Assetsid->CurrentValue = $this->Assetsid->FormValue;
        $this->MDA_Parent->CurrentValue = $this->MDA_Parent->FormValue;
        $this->MDA_id->CurrentValue = $this->MDA_id->FormValue;
        $this->Location_id->CurrentValue = $this->Location_id->FormValue;
        $this->Asset_Status->CurrentValue = $this->Asset_Status->FormValue;
        $this->Category_Temp->CurrentValue = $this->Category_Temp->FormValue;
        $this->Make->CurrentValue = $this->Make->FormValue;
        $this->Model->CurrentValue = $this->Model->FormValue;
        $this->YearofManufacture->CurrentValue = $this->YearofManufacture->FormValue;
        $this->Colour->CurrentValue = $this->Colour->FormValue;
        $this->EngineNumber->CurrentValue = $this->EngineNumber->FormValue;
        $this->ChasisNumber->CurrentValue = $this->ChasisNumber->FormValue;
        $this->CivilianPlateNumber->CurrentValue = $this->CivilianPlateNumber->FormValue;
        $this->GovtPlateNumber->CurrentValue = $this->GovtPlateNumber->FormValue;
        $this->Asset_No->CurrentValue = $this->Asset_No->FormValue;
        $this->Details_of_Asset->CurrentValue = $this->Details_of_Asset->FormValue;
        $this->Condition_Of_Asset->CurrentValue = $this->Condition_Of_Asset->FormValue;
        $this->Custodian_id->CurrentValue = $this->Custodian_id->FormValue;
        $this->Date_of_Acquisition->CurrentValue = $this->Date_of_Acquisition->FormValue;
        $this->Date_of_Acquisition->CurrentValue = UnFormatDateTime($this->Date_of_Acquisition->CurrentValue, 0);
        $this->Aquistion_Cost->CurrentValue = $this->Aquistion_Cost->FormValue;
        $this->Additional_Cost->CurrentValue = $this->Additional_Cost->FormValue;
        $this->Revaluation_Cost->CurrentValue = $this->Revaluation_Cost->FormValue;
        $this->Remarks->CurrentValue = $this->Remarks->FormValue;
        $this->Updated_on->CurrentValue = $this->Updated_on->FormValue;
        $this->Updated_on->CurrentValue = UnFormatDateTime($this->Updated_on->CurrentValue, 0);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }

        // Check if valid User ID
        if ($res) {
            $res = $this->showOptionLink("edit");
            if (!$res) {
                $userIdMsg = DeniedMessage();
                $this->setFailureMessage($userIdMsg);
            }
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->Assetsid->setDbValue($row['Assetsid']);
        $this->MDA_Parent->setDbValue($row['MDA_Parent']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Location_id->setDbValue($row['Location_id']);
        $this->Asset_Status->setDbValue($row['Asset_Status']);
        $this->Category_Temp->setDbValue($row['Category_Temp']);
        $this->Make->setDbValue($row['Make']);
        $this->Model->setDbValue($row['Model']);
        $this->YearofManufacture->setDbValue($row['Year of Manufacture']);
        $this->Colour->setDbValue($row['Colour']);
        $this->EngineNumber->setDbValue($row['Engine Number']);
        $this->ChasisNumber->setDbValue($row['Chasis Number']);
        $this->CivilianPlateNumber->setDbValue($row['Civilian Plate Number']);
        $this->GovtPlateNumber->setDbValue($row['Govt Plate Number']);
        $this->Asset_No->setDbValue($row['Asset_No']);
        $this->Details_of_Asset->setDbValue($row['Details_of_Asset']);
        $this->Condition_Of_Asset->setDbValue($row['Condition_Of_Asset']);
        $this->Custodian_id->setDbValue($row['Custodian_id']);
        $this->Category->setDbValue($row['Category']);
        $this->Category_Details->setDbValue($row['Category_Details']);
        $this->Date_of_Acquisition->setDbValue($row['Date_of_Acquisition']);
        $this->Aquistion_Cost->setDbValue($row['Aquistion_Cost']);
        $this->Additional_Cost->setDbValue($row['Additional_Cost']);
        $this->Revaluation_Cost->setDbValue($row['Revaluation_Cost']);
        $this->Remarks->setDbValue($row['Remarks']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->MDA_temp->setDbValue($row['MDA_temp']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['Assetsid'] = null;
        $row['MDA_Parent'] = null;
        $row['MDA_id'] = null;
        $row['Location_id'] = null;
        $row['Asset_Status'] = null;
        $row['Category_Temp'] = null;
        $row['Make'] = null;
        $row['Model'] = null;
        $row['Year of Manufacture'] = null;
        $row['Colour'] = null;
        $row['Engine Number'] = null;
        $row['Chasis Number'] = null;
        $row['Civilian Plate Number'] = null;
        $row['Govt Plate Number'] = null;
        $row['Asset_No'] = null;
        $row['Details_of_Asset'] = null;
        $row['Condition_Of_Asset'] = null;
        $row['Custodian_id'] = null;
        $row['Category'] = null;
        $row['Category_Details'] = null;
        $row['Date_of_Acquisition'] = null;
        $row['Aquistion_Cost'] = null;
        $row['Additional_Cost'] = null;
        $row['Revaluation_Cost'] = null;
        $row['Remarks'] = null;
        $row['Created_on'] = null;
        $row['Updated_on'] = null;
        $row['Created_By'] = null;
        $row['MDA_temp'] = null;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Convert decimal values if posted back
        if ($this->Aquistion_Cost->FormValue == $this->Aquistion_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Aquistion_Cost->CurrentValue))) {
            $this->Aquistion_Cost->CurrentValue = ConvertToFloatString($this->Aquistion_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Additional_Cost->FormValue == $this->Additional_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Additional_Cost->CurrentValue))) {
            $this->Additional_Cost->CurrentValue = ConvertToFloatString($this->Additional_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Revaluation_Cost->FormValue == $this->Revaluation_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Revaluation_Cost->CurrentValue))) {
            $this->Revaluation_Cost->CurrentValue = ConvertToFloatString($this->Revaluation_Cost->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Assetsid

        // MDA_Parent

        // MDA_id

        // Location_id

        // Asset_Status

        // Category_Temp

        // Make

        // Model

        // Year of Manufacture

        // Colour

        // Engine Number

        // Chasis Number

        // Civilian Plate Number

        // Govt Plate Number

        // Asset_No

        // Details_of_Asset

        // Condition_Of_Asset

        // Custodian_id

        // Category

        // Category_Details

        // Date_of_Acquisition

        // Aquistion_Cost

        // Additional_Cost

        // Revaluation_Cost

        // Remarks

        // Created_on

        // Updated_on

        // Created_By

        // MDA_temp
        if ($this->RowType == ROWTYPE_VIEW) {
            // Assetsid
            $this->Assetsid->ViewValue = $this->Assetsid->CurrentValue;
            $this->Assetsid->CellCssStyle .= "text-align: right;";
            $this->Assetsid->ViewCustomAttributes = "";

            // MDA_Parent
            $curVal = trim(strval($this->MDA_Parent->CurrentValue));
            if ($curVal != "") {
                $this->MDA_Parent->ViewValue = $this->MDA_Parent->lookupCacheOption($curVal);
                if ($this->MDA_Parent->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Parent`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->MDA_Parent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_Parent->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_Parent->ViewValue = $this->MDA_Parent->displayValue($arwrk);
                    } else {
                        $this->MDA_Parent->ViewValue = $this->MDA_Parent->CurrentValue;
                    }
                }
            } else {
                $this->MDA_Parent->ViewValue = null;
            }
            $this->MDA_Parent->ViewCustomAttributes = "";

            // MDA_id
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->ViewValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";

            // Location_id
            $curVal = trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
                if ($this->Location_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                    } else {
                        $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                    }
                }
            } else {
                $this->Location_id->ViewValue = null;
            }
            $this->Location_id->ViewCustomAttributes = "";

            // Asset_Status
            $curVal = trim(strval($this->Asset_Status->CurrentValue));
            if ($curVal != "") {
                $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
                if ($this->Asset_Status->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Asset_Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Asset_Status->Lookup->renderViewRow($rswrk[0]);
                        $this->Asset_Status->ViewValue = $this->Asset_Status->displayValue($arwrk);
                    } else {
                        $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
                    }
                }
            } else {
                $this->Asset_Status->ViewValue = null;
            }
            $this->Asset_Status->ViewCustomAttributes = "";

            // Category_Temp
            $curVal = trim(strval($this->Category_Temp->CurrentValue));
            if ($curVal != "") {
                $this->Category_Temp->ViewValue = $this->Category_Temp->lookupCacheOption($curVal);
                if ($this->Category_Temp->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Category_Details`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Category_Temp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category_Temp->Lookup->renderViewRow($rswrk[0]);
                        $this->Category_Temp->ViewValue = $this->Category_Temp->displayValue($arwrk);
                    } else {
                        $this->Category_Temp->ViewValue = $this->Category_Temp->CurrentValue;
                    }
                }
            } else {
                $this->Category_Temp->ViewValue = null;
            }
            $this->Category_Temp->ViewCustomAttributes = "";

            // Make
            $this->Make->ViewValue = $this->Make->CurrentValue;
            $curVal = trim(strval($this->Make->CurrentValue));
            if ($curVal != "") {
                $this->Make->ViewValue = $this->Make->lookupCacheOption($curVal);
                if ($this->Make->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Make->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Make->Lookup->renderViewRow($rswrk[0]);
                        $this->Make->ViewValue = $this->Make->displayValue($arwrk);
                    } else {
                        $this->Make->ViewValue = $this->Make->CurrentValue;
                    }
                }
            } else {
                $this->Make->ViewValue = null;
            }
            $this->Make->ViewCustomAttributes = "";

            // Model
            $this->Model->ViewValue = $this->Model->CurrentValue;
            $curVal = trim(strval($this->Model->CurrentValue));
            if ($curVal != "") {
                $this->Model->ViewValue = $this->Model->lookupCacheOption($curVal);
                if ($this->Model->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Model->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Model->Lookup->renderViewRow($rswrk[0]);
                        $this->Model->ViewValue = $this->Model->displayValue($arwrk);
                    } else {
                        $this->Model->ViewValue = $this->Model->CurrentValue;
                    }
                }
            } else {
                $this->Model->ViewValue = null;
            }
            $this->Model->ViewCustomAttributes = "";

            // Year of Manufacture
            $this->YearofManufacture->ViewValue = $this->YearofManufacture->CurrentValue;
            $this->YearofManufacture->ViewCustomAttributes = "";

            // Colour
            $this->Colour->ViewValue = $this->Colour->CurrentValue;
            $this->Colour->ViewCustomAttributes = "";

            // Engine Number
            $this->EngineNumber->ViewValue = $this->EngineNumber->CurrentValue;
            $this->EngineNumber->ViewCustomAttributes = "";

            // Chasis Number
            $this->ChasisNumber->ViewValue = $this->ChasisNumber->CurrentValue;
            $this->ChasisNumber->ViewCustomAttributes = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->ViewValue = $this->CivilianPlateNumber->CurrentValue;
            $this->CivilianPlateNumber->ViewCustomAttributes = "";

            // Govt Plate Number
            $this->GovtPlateNumber->ViewValue = $this->GovtPlateNumber->CurrentValue;
            $this->GovtPlateNumber->ViewCustomAttributes = "";

            // Asset_No
            $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
            $this->Asset_No->ViewCustomAttributes = "";

            // Details_of_Asset
            $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
            $this->Details_of_Asset->CellCssStyle .= "text-align: left;";
            $this->Details_of_Asset->ViewCustomAttributes = "";

            // Condition_Of_Asset
            $curVal = trim(strval($this->Condition_Of_Asset->CurrentValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
                if ($this->Condition_Of_Asset->ViewValue === null) { // Lookup from database
                    $filterWrk = "`status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Condition_Of_Asset->Lookup->renderViewRow($rswrk[0]);
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->displayValue($arwrk);
                    } else {
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
                    }
                }
            } else {
                $this->Condition_Of_Asset->ViewValue = null;
            }
            $this->Condition_Of_Asset->ViewCustomAttributes = "";

            // Custodian_id
            $curVal = trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
                if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Custodian_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Custodian_id->ViewValue = $this->Custodian_id->displayValue($arwrk);
                    } else {
                        $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                    }
                }
            } else {
                $this->Custodian_id->ViewValue = null;
            }
            $this->Custodian_id->ViewCustomAttributes = "";

            // Category_Details
            $curVal = trim(strval($this->Category_Details->CurrentValue));
            if ($curVal != "") {
                $this->Category_Details->ViewValue = $this->Category_Details->lookupCacheOption($curVal);
                if ($this->Category_Details->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Category_Details`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Category_Details->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category_Details->Lookup->renderViewRow($rswrk[0]);
                        $this->Category_Details->ViewValue = $this->Category_Details->displayValue($arwrk);
                    } else {
                        $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
                    }
                }
            } else {
                $this->Category_Details->ViewValue = null;
            }
            $this->Category_Details->ViewCustomAttributes = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
            $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
            $this->Date_of_Acquisition->ViewCustomAttributes = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -1, -2);
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";

            // Additional_Cost
            $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";

            // Remarks
            $this->Remarks->ViewValue = $this->Remarks->CurrentValue;
            $this->Remarks->CellCssStyle .= "text-align: left;";
            $this->Remarks->ViewCustomAttributes = "";

            // Updated_on
            $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
            $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
            $this->Updated_on->ViewCustomAttributes = "";

            // MDA_Parent
            $this->MDA_Parent->LinkCustomAttributes = "";
            $this->MDA_Parent->HrefValue = "";
            $this->MDA_Parent->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";
            $this->Location_id->TooltipValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";
            $this->Asset_Status->TooltipValue = "";

            // Category_Temp
            $this->Category_Temp->LinkCustomAttributes = "";
            $this->Category_Temp->HrefValue = "";
            $this->Category_Temp->TooltipValue = "";

            // Make
            $this->Make->LinkCustomAttributes = "";
            $this->Make->HrefValue = "";
            $this->Make->TooltipValue = "";

            // Model
            $this->Model->LinkCustomAttributes = "";
            $this->Model->HrefValue = "";
            $this->Model->TooltipValue = "";

            // Year of Manufacture
            $this->YearofManufacture->LinkCustomAttributes = "";
            $this->YearofManufacture->HrefValue = "";
            $this->YearofManufacture->TooltipValue = "";

            // Colour
            $this->Colour->LinkCustomAttributes = "";
            $this->Colour->HrefValue = "";
            $this->Colour->TooltipValue = "";

            // Engine Number
            $this->EngineNumber->LinkCustomAttributes = "";
            $this->EngineNumber->HrefValue = "";
            $this->EngineNumber->TooltipValue = "";

            // Chasis Number
            $this->ChasisNumber->LinkCustomAttributes = "";
            $this->ChasisNumber->HrefValue = "";
            $this->ChasisNumber->TooltipValue = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->LinkCustomAttributes = "";
            $this->CivilianPlateNumber->HrefValue = "";
            $this->CivilianPlateNumber->TooltipValue = "";

            // Govt Plate Number
            $this->GovtPlateNumber->LinkCustomAttributes = "";
            $this->GovtPlateNumber->HrefValue = "";
            $this->GovtPlateNumber->TooltipValue = "";

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";
            $this->Asset_No->TooltipValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";
            $this->Details_of_Asset->TooltipValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";
            $this->Condition_Of_Asset->TooltipValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";
            $this->Custodian_id->TooltipValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";
            $this->Date_of_Acquisition->TooltipValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";
            $this->Aquistion_Cost->TooltipValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";
            $this->Additional_Cost->TooltipValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";
            $this->Revaluation_Cost->TooltipValue = "";

            // Remarks
            $this->Remarks->LinkCustomAttributes = "";
            $this->Remarks->HrefValue = "";
            $this->Remarks->TooltipValue = "";

            // Updated_on
            $this->Updated_on->LinkCustomAttributes = "";
            $this->Updated_on->HrefValue = "";
            $this->Updated_on->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // MDA_Parent
            $this->MDA_Parent->EditAttrs["class"] = "form-control";
            $this->MDA_Parent->EditCustomAttributes = "";
            $curVal = trim(strval($this->MDA_Parent->CurrentValue));
            if ($curVal != "") {
                $this->MDA_Parent->ViewValue = $this->MDA_Parent->lookupCacheOption($curVal);
            } else {
                $this->MDA_Parent->ViewValue = $this->MDA_Parent->Lookup !== null && is_array($this->MDA_Parent->Lookup->Options) ? $curVal : null;
            }
            if ($this->MDA_Parent->ViewValue !== null) { // Load from cache
                $this->MDA_Parent->EditValue = array_values($this->MDA_Parent->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Parent`" . SearchString("=", $this->MDA_Parent->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->MDA_Parent->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->MDA_Parent->EditValue = $arwrk;
            }
            $this->MDA_Parent->PlaceHolder = RemoveHtml($this->MDA_Parent->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("edit")) { // Non system admin
                $this->MDA_id->CurrentValue = CurrentUserID();
                $curVal = trim(strval($this->MDA_id->CurrentValue));
                if ($curVal != "") {
                    $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                    if ($this->MDA_id->EditValue === null) { // Lookup from database
                        $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                            $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                        } else {
                            $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                        }
                    }
                } else {
                    $this->MDA_id->EditValue = null;
                }
                $this->MDA_id->ViewCustomAttributes = "";
            } else {
                $curVal = trim(strval($this->MDA_id->CurrentValue));
                if ($curVal != "") {
                    $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                } else {
                    $this->MDA_id->ViewValue = $this->MDA_id->Lookup !== null && is_array($this->MDA_id->Lookup->Options) ? $curVal : null;
                }
                if ($this->MDA_id->ViewValue !== null) { // Load from cache
                    $this->MDA_id->EditValue = array_values($this->MDA_id->Lookup->Options);
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = "`MDAID`" . SearchString("=", $this->MDA_id->CurrentValue, DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->MDA_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->MDA_id->EditValue = $arwrk;
                }
                $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
            }

            // Location_id
            $this->Location_id->EditAttrs["class"] = "form-control";
            $this->Location_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
            } else {
                $this->Location_id->ViewValue = $this->Location_id->Lookup !== null && is_array($this->Location_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Location_id->ViewValue !== null) { // Load from cache
                $this->Location_id->EditValue = array_values($this->Location_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Locationid`" . SearchString("=", $this->Location_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Location_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Location_id->EditValue = $arwrk;
            }
            $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

            // Asset_Status
            $this->Asset_Status->EditAttrs["class"] = "form-control";
            $this->Asset_Status->EditCustomAttributes = "";
            $curVal = trim(strval($this->Asset_Status->CurrentValue));
            if ($curVal != "") {
                $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
            } else {
                $this->Asset_Status->ViewValue = $this->Asset_Status->Lookup !== null && is_array($this->Asset_Status->Lookup->Options) ? $curVal : null;
            }
            if ($this->Asset_Status->ViewValue !== null) { // Load from cache
                $this->Asset_Status->EditValue = array_values($this->Asset_Status->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Status`" . SearchString("=", $this->Asset_Status->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Asset_Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Asset_Status->EditValue = $arwrk;
            }
            $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

            // Category_Temp
            $this->Category_Temp->EditAttrs["class"] = "form-control";
            $this->Category_Temp->EditCustomAttributes = "";
            $curVal = trim(strval($this->Category_Temp->CurrentValue));
            if ($curVal != "") {
                $this->Category_Temp->ViewValue = $this->Category_Temp->lookupCacheOption($curVal);
            } else {
                $this->Category_Temp->ViewValue = $this->Category_Temp->Lookup !== null && is_array($this->Category_Temp->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category_Temp->ViewValue !== null) { // Load from cache
                $this->Category_Temp->EditValue = array_values($this->Category_Temp->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Category_Details`" . SearchString("=", $this->Category_Temp->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Category_Temp->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category_Temp->EditValue = $arwrk;
            }
            $this->Category_Temp->PlaceHolder = RemoveHtml($this->Category_Temp->caption());

            // Make
            $this->Make->EditAttrs["class"] = "form-control";
            $this->Make->EditCustomAttributes = "";
            if (!$this->Make->Raw) {
                $this->Make->CurrentValue = HtmlDecode($this->Make->CurrentValue);
            }
            $this->Make->EditValue = HtmlEncode($this->Make->CurrentValue);
            $curVal = trim(strval($this->Make->CurrentValue));
            if ($curVal != "") {
                $this->Make->EditValue = $this->Make->lookupCacheOption($curVal);
                if ($this->Make->EditValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Make->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Make->Lookup->renderViewRow($rswrk[0]);
                        $this->Make->EditValue = $this->Make->displayValue($arwrk);
                    } else {
                        $this->Make->EditValue = HtmlEncode($this->Make->CurrentValue);
                    }
                }
            } else {
                $this->Make->EditValue = null;
            }
            $this->Make->PlaceHolder = RemoveHtml($this->Make->caption());

            // Model
            $this->Model->EditAttrs["class"] = "form-control";
            $this->Model->EditCustomAttributes = "";
            if (!$this->Model->Raw) {
                $this->Model->CurrentValue = HtmlDecode($this->Model->CurrentValue);
            }
            $this->Model->EditValue = HtmlEncode($this->Model->CurrentValue);
            $curVal = trim(strval($this->Model->CurrentValue));
            if ($curVal != "") {
                $this->Model->EditValue = $this->Model->lookupCacheOption($curVal);
                if ($this->Model->EditValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Model->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Model->Lookup->renderViewRow($rswrk[0]);
                        $this->Model->EditValue = $this->Model->displayValue($arwrk);
                    } else {
                        $this->Model->EditValue = HtmlEncode($this->Model->CurrentValue);
                    }
                }
            } else {
                $this->Model->EditValue = null;
            }
            $this->Model->PlaceHolder = RemoveHtml($this->Model->caption());

            // Year of Manufacture
            $this->YearofManufacture->EditAttrs["class"] = "form-control";
            $this->YearofManufacture->EditCustomAttributes = "";
            $this->YearofManufacture->EditValue = HtmlEncode($this->YearofManufacture->CurrentValue);
            $this->YearofManufacture->PlaceHolder = RemoveHtml($this->YearofManufacture->caption());

            // Colour
            $this->Colour->EditAttrs["class"] = "form-control";
            $this->Colour->EditCustomAttributes = "";
            if (!$this->Colour->Raw) {
                $this->Colour->CurrentValue = HtmlDecode($this->Colour->CurrentValue);
            }
            $this->Colour->EditValue = HtmlEncode($this->Colour->CurrentValue);
            $this->Colour->PlaceHolder = RemoveHtml($this->Colour->caption());

            // Engine Number
            $this->EngineNumber->EditAttrs["class"] = "form-control";
            $this->EngineNumber->EditCustomAttributes = "";
            if (!$this->EngineNumber->Raw) {
                $this->EngineNumber->CurrentValue = HtmlDecode($this->EngineNumber->CurrentValue);
            }
            $this->EngineNumber->EditValue = HtmlEncode($this->EngineNumber->CurrentValue);
            $this->EngineNumber->PlaceHolder = RemoveHtml($this->EngineNumber->caption());

            // Chasis Number
            $this->ChasisNumber->EditAttrs["class"] = "form-control";
            $this->ChasisNumber->EditCustomAttributes = "";
            if (!$this->ChasisNumber->Raw) {
                $this->ChasisNumber->CurrentValue = HtmlDecode($this->ChasisNumber->CurrentValue);
            }
            $this->ChasisNumber->EditValue = HtmlEncode($this->ChasisNumber->CurrentValue);
            $this->ChasisNumber->PlaceHolder = RemoveHtml($this->ChasisNumber->caption());

            // Civilian Plate Number
            $this->CivilianPlateNumber->EditAttrs["class"] = "form-control";
            $this->CivilianPlateNumber->EditCustomAttributes = "";
            if (!$this->CivilianPlateNumber->Raw) {
                $this->CivilianPlateNumber->CurrentValue = HtmlDecode($this->CivilianPlateNumber->CurrentValue);
            }
            $this->CivilianPlateNumber->EditValue = HtmlEncode($this->CivilianPlateNumber->CurrentValue);
            $this->CivilianPlateNumber->PlaceHolder = RemoveHtml($this->CivilianPlateNumber->caption());

            // Govt Plate Number
            $this->GovtPlateNumber->EditAttrs["class"] = "form-control";
            $this->GovtPlateNumber->EditCustomAttributes = "";
            if (!$this->GovtPlateNumber->Raw) {
                $this->GovtPlateNumber->CurrentValue = HtmlDecode($this->GovtPlateNumber->CurrentValue);
            }
            $this->GovtPlateNumber->EditValue = HtmlEncode($this->GovtPlateNumber->CurrentValue);
            $this->GovtPlateNumber->PlaceHolder = RemoveHtml($this->GovtPlateNumber->caption());

            // Asset_No
            $this->Asset_No->EditAttrs["class"] = "form-control";
            $this->Asset_No->EditCustomAttributes = "";
            if (!$this->Asset_No->Raw) {
                $this->Asset_No->CurrentValue = HtmlDecode($this->Asset_No->CurrentValue);
            }
            $this->Asset_No->EditValue = HtmlEncode($this->Asset_No->CurrentValue);
            $this->Asset_No->PlaceHolder = RemoveHtml($this->Asset_No->caption());

            // Details_of_Asset
            $this->Details_of_Asset->EditAttrs["class"] = "form-control";
            $this->Details_of_Asset->EditCustomAttributes = "";
            if (!$this->Details_of_Asset->Raw) {
                $this->Details_of_Asset->CurrentValue = HtmlDecode($this->Details_of_Asset->CurrentValue);
            }
            $this->Details_of_Asset->EditValue = HtmlEncode($this->Details_of_Asset->CurrentValue);
            $this->Details_of_Asset->PlaceHolder = RemoveHtml($this->Details_of_Asset->caption());

            // Condition_Of_Asset
            $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
            $this->Condition_Of_Asset->EditCustomAttributes = "";
            $curVal = trim(strval($this->Condition_Of_Asset->CurrentValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
            } else {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->Lookup !== null && is_array($this->Condition_Of_Asset->Lookup->Options) ? $curVal : null;
            }
            if ($this->Condition_Of_Asset->ViewValue !== null) { // Load from cache
                $this->Condition_Of_Asset->EditValue = array_values($this->Condition_Of_Asset->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`status`" . SearchString("=", $this->Condition_Of_Asset->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Condition_Of_Asset->EditValue = $arwrk;
            }
            $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

            // Custodian_id
            $this->Custodian_id->EditAttrs["class"] = "form-control";
            $this->Custodian_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
            } else {
                $this->Custodian_id->ViewValue = $this->Custodian_id->Lookup !== null && is_array($this->Custodian_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Custodian_id->ViewValue !== null) { // Load from cache
                $this->Custodian_id->EditValue = array_values($this->Custodian_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->Custodian_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Custodian_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Custodian_id->EditValue = $arwrk;
            }
            $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

            // Date_of_Acquisition
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue = HtmlEncode(FormatDateTime($this->Date_of_Acquisition->CurrentValue, 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

            // Aquistion_Cost
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue = HtmlEncode($this->Aquistion_Cost->CurrentValue);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());
            if (strval($this->Aquistion_Cost->EditValue) != "" && is_numeric($this->Aquistion_Cost->EditValue)) {
                $this->Aquistion_Cost->EditValue = FormatNumber($this->Aquistion_Cost->EditValue, -2, -2, -2, -2);
            }

            // Additional_Cost
            $this->Additional_Cost->EditAttrs["class"] = "form-control";
            $this->Additional_Cost->EditCustomAttributes = "";
            $this->Additional_Cost->EditValue = HtmlEncode($this->Additional_Cost->CurrentValue);
            $this->Additional_Cost->PlaceHolder = RemoveHtml($this->Additional_Cost->caption());
            if (strval($this->Additional_Cost->EditValue) != "" && is_numeric($this->Additional_Cost->EditValue)) {
                $this->Additional_Cost->EditValue = FormatNumber($this->Additional_Cost->EditValue, -2, -2, -2, -2);
            }

            // Revaluation_Cost
            $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
            $this->Revaluation_Cost->EditCustomAttributes = "";
            $this->Revaluation_Cost->EditValue = HtmlEncode($this->Revaluation_Cost->CurrentValue);
            $this->Revaluation_Cost->PlaceHolder = RemoveHtml($this->Revaluation_Cost->caption());
            if (strval($this->Revaluation_Cost->EditValue) != "" && is_numeric($this->Revaluation_Cost->EditValue)) {
                $this->Revaluation_Cost->EditValue = FormatNumber($this->Revaluation_Cost->EditValue, -2, -2, -2, -2);
            }

            // Remarks
            $this->Remarks->EditAttrs["class"] = "form-control";
            $this->Remarks->EditCustomAttributes = "";
            $this->Remarks->EditValue = HtmlEncode($this->Remarks->CurrentValue);
            $this->Remarks->PlaceHolder = RemoveHtml($this->Remarks->caption());

            // Updated_on

            // Edit refer script

            // MDA_Parent
            $this->MDA_Parent->LinkCustomAttributes = "";
            $this->MDA_Parent->HrefValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";

            // Category_Temp
            $this->Category_Temp->LinkCustomAttributes = "";
            $this->Category_Temp->HrefValue = "";

            // Make
            $this->Make->LinkCustomAttributes = "";
            $this->Make->HrefValue = "";

            // Model
            $this->Model->LinkCustomAttributes = "";
            $this->Model->HrefValue = "";

            // Year of Manufacture
            $this->YearofManufacture->LinkCustomAttributes = "";
            $this->YearofManufacture->HrefValue = "";

            // Colour
            $this->Colour->LinkCustomAttributes = "";
            $this->Colour->HrefValue = "";

            // Engine Number
            $this->EngineNumber->LinkCustomAttributes = "";
            $this->EngineNumber->HrefValue = "";

            // Chasis Number
            $this->ChasisNumber->LinkCustomAttributes = "";
            $this->ChasisNumber->HrefValue = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->LinkCustomAttributes = "";
            $this->CivilianPlateNumber->HrefValue = "";

            // Govt Plate Number
            $this->GovtPlateNumber->LinkCustomAttributes = "";
            $this->GovtPlateNumber->HrefValue = "";

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";

            // Remarks
            $this->Remarks->LinkCustomAttributes = "";
            $this->Remarks->HrefValue = "";

            // Updated_on
            $this->Updated_on->LinkCustomAttributes = "";
            $this->Updated_on->HrefValue = "";
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->MDA_Parent->Required) {
            if (!$this->MDA_Parent->IsDetailKey && EmptyValue($this->MDA_Parent->FormValue)) {
                $this->MDA_Parent->addErrorMessage(str_replace("%s", $this->MDA_Parent->caption(), $this->MDA_Parent->RequiredErrorMessage));
            }
        }
        if ($this->MDA_id->Required) {
            if (!$this->MDA_id->IsDetailKey && EmptyValue($this->MDA_id->FormValue)) {
                $this->MDA_id->addErrorMessage(str_replace("%s", $this->MDA_id->caption(), $this->MDA_id->RequiredErrorMessage));
            }
        }
        if ($this->Location_id->Required) {
            if (!$this->Location_id->IsDetailKey && EmptyValue($this->Location_id->FormValue)) {
                $this->Location_id->addErrorMessage(str_replace("%s", $this->Location_id->caption(), $this->Location_id->RequiredErrorMessage));
            }
        }
        if ($this->Asset_Status->Required) {
            if (!$this->Asset_Status->IsDetailKey && EmptyValue($this->Asset_Status->FormValue)) {
                $this->Asset_Status->addErrorMessage(str_replace("%s", $this->Asset_Status->caption(), $this->Asset_Status->RequiredErrorMessage));
            }
        }
        if ($this->Category_Temp->Required) {
            if (!$this->Category_Temp->IsDetailKey && EmptyValue($this->Category_Temp->FormValue)) {
                $this->Category_Temp->addErrorMessage(str_replace("%s", $this->Category_Temp->caption(), $this->Category_Temp->RequiredErrorMessage));
            }
        }
        if ($this->Make->Required) {
            if (!$this->Make->IsDetailKey && EmptyValue($this->Make->FormValue)) {
                $this->Make->addErrorMessage(str_replace("%s", $this->Make->caption(), $this->Make->RequiredErrorMessage));
            }
        }
        if ($this->Model->Required) {
            if (!$this->Model->IsDetailKey && EmptyValue($this->Model->FormValue)) {
                $this->Model->addErrorMessage(str_replace("%s", $this->Model->caption(), $this->Model->RequiredErrorMessage));
            }
        }
        if ($this->YearofManufacture->Required) {
            if (!$this->YearofManufacture->IsDetailKey && EmptyValue($this->YearofManufacture->FormValue)) {
                $this->YearofManufacture->addErrorMessage(str_replace("%s", $this->YearofManufacture->caption(), $this->YearofManufacture->RequiredErrorMessage));
            }
        }
        if (!CheckInteger($this->YearofManufacture->FormValue)) {
            $this->YearofManufacture->addErrorMessage($this->YearofManufacture->getErrorMessage(false));
        }
        if ($this->Colour->Required) {
            if (!$this->Colour->IsDetailKey && EmptyValue($this->Colour->FormValue)) {
                $this->Colour->addErrorMessage(str_replace("%s", $this->Colour->caption(), $this->Colour->RequiredErrorMessage));
            }
        }
        if ($this->EngineNumber->Required) {
            if (!$this->EngineNumber->IsDetailKey && EmptyValue($this->EngineNumber->FormValue)) {
                $this->EngineNumber->addErrorMessage(str_replace("%s", $this->EngineNumber->caption(), $this->EngineNumber->RequiredErrorMessage));
            }
        }
        if ($this->ChasisNumber->Required) {
            if (!$this->ChasisNumber->IsDetailKey && EmptyValue($this->ChasisNumber->FormValue)) {
                $this->ChasisNumber->addErrorMessage(str_replace("%s", $this->ChasisNumber->caption(), $this->ChasisNumber->RequiredErrorMessage));
            }
        }
        if ($this->CivilianPlateNumber->Required) {
            if (!$this->CivilianPlateNumber->IsDetailKey && EmptyValue($this->CivilianPlateNumber->FormValue)) {
                $this->CivilianPlateNumber->addErrorMessage(str_replace("%s", $this->CivilianPlateNumber->caption(), $this->CivilianPlateNumber->RequiredErrorMessage));
            }
        }
        if ($this->GovtPlateNumber->Required) {
            if (!$this->GovtPlateNumber->IsDetailKey && EmptyValue($this->GovtPlateNumber->FormValue)) {
                $this->GovtPlateNumber->addErrorMessage(str_replace("%s", $this->GovtPlateNumber->caption(), $this->GovtPlateNumber->RequiredErrorMessage));
            }
        }
        if ($this->Asset_No->Required) {
            if (!$this->Asset_No->IsDetailKey && EmptyValue($this->Asset_No->FormValue)) {
                $this->Asset_No->addErrorMessage(str_replace("%s", $this->Asset_No->caption(), $this->Asset_No->RequiredErrorMessage));
            }
        }
        if ($this->Details_of_Asset->Required) {
            if (!$this->Details_of_Asset->IsDetailKey && EmptyValue($this->Details_of_Asset->FormValue)) {
                $this->Details_of_Asset->addErrorMessage(str_replace("%s", $this->Details_of_Asset->caption(), $this->Details_of_Asset->RequiredErrorMessage));
            }
        }
        if ($this->Condition_Of_Asset->Required) {
            if (!$this->Condition_Of_Asset->IsDetailKey && EmptyValue($this->Condition_Of_Asset->FormValue)) {
                $this->Condition_Of_Asset->addErrorMessage(str_replace("%s", $this->Condition_Of_Asset->caption(), $this->Condition_Of_Asset->RequiredErrorMessage));
            }
        }
        if ($this->Custodian_id->Required) {
            if (!$this->Custodian_id->IsDetailKey && EmptyValue($this->Custodian_id->FormValue)) {
                $this->Custodian_id->addErrorMessage(str_replace("%s", $this->Custodian_id->caption(), $this->Custodian_id->RequiredErrorMessage));
            }
        }
        if ($this->Date_of_Acquisition->Required) {
            if (!$this->Date_of_Acquisition->IsDetailKey && EmptyValue($this->Date_of_Acquisition->FormValue)) {
                $this->Date_of_Acquisition->addErrorMessage(str_replace("%s", $this->Date_of_Acquisition->caption(), $this->Date_of_Acquisition->RequiredErrorMessage));
            }
        }
        if (!CheckDate($this->Date_of_Acquisition->FormValue)) {
            $this->Date_of_Acquisition->addErrorMessage($this->Date_of_Acquisition->getErrorMessage(false));
        }
        if ($this->Aquistion_Cost->Required) {
            if (!$this->Aquistion_Cost->IsDetailKey && EmptyValue($this->Aquistion_Cost->FormValue)) {
                $this->Aquistion_Cost->addErrorMessage(str_replace("%s", $this->Aquistion_Cost->caption(), $this->Aquistion_Cost->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->Aquistion_Cost->FormValue)) {
            $this->Aquistion_Cost->addErrorMessage($this->Aquistion_Cost->getErrorMessage(false));
        }
        if ($this->Additional_Cost->Required) {
            if (!$this->Additional_Cost->IsDetailKey && EmptyValue($this->Additional_Cost->FormValue)) {
                $this->Additional_Cost->addErrorMessage(str_replace("%s", $this->Additional_Cost->caption(), $this->Additional_Cost->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->Additional_Cost->FormValue)) {
            $this->Additional_Cost->addErrorMessage($this->Additional_Cost->getErrorMessage(false));
        }
        if ($this->Revaluation_Cost->Required) {
            if (!$this->Revaluation_Cost->IsDetailKey && EmptyValue($this->Revaluation_Cost->FormValue)) {
                $this->Revaluation_Cost->addErrorMessage(str_replace("%s", $this->Revaluation_Cost->caption(), $this->Revaluation_Cost->RequiredErrorMessage));
            }
        }
        if (!CheckNumber($this->Revaluation_Cost->FormValue)) {
            $this->Revaluation_Cost->addErrorMessage($this->Revaluation_Cost->getErrorMessage(false));
        }
        if ($this->Remarks->Required) {
            if (!$this->Remarks->IsDetailKey && EmptyValue($this->Remarks->FormValue)) {
                $this->Remarks->addErrorMessage(str_replace("%s", $this->Remarks->caption(), $this->Remarks->RequiredErrorMessage));
            }
        }
        if ($this->Updated_on->Required) {
            if (!$this->Updated_on->IsDetailKey && EmptyValue($this->Updated_on->FormValue)) {
                $this->Updated_on->addErrorMessage(str_replace("%s", $this->Updated_on->caption(), $this->Updated_on->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();
        if ($this->Asset_No->CurrentValue != "") { // Check field with unique index
            $filterChk = "(`Asset_No` = '" . AdjustSql($this->Asset_No->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->Asset_No->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->Asset_No->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                $rsChk->closeCursor();
                return false;
            }
        }
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssoc($sql);
        $editRow = false;
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            $editRow = false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
            $rsnew = [];

            // MDA_Parent
            $this->MDA_Parent->setDbValueDef($rsnew, $this->MDA_Parent->CurrentValue, null, $this->MDA_Parent->ReadOnly);

            // MDA_id
            $this->MDA_id->setDbValueDef($rsnew, $this->MDA_id->CurrentValue, 0, $this->MDA_id->ReadOnly);

            // Location_id
            $this->Location_id->setDbValueDef($rsnew, $this->Location_id->CurrentValue, 0, $this->Location_id->ReadOnly);

            // Asset_Status
            $this->Asset_Status->setDbValueDef($rsnew, $this->Asset_Status->CurrentValue, "", $this->Asset_Status->ReadOnly);

            // Category_Temp
            $this->Category_Temp->setDbValueDef($rsnew, $this->Category_Temp->CurrentValue, "", $this->Category_Temp->ReadOnly);

            // Make
            $this->Make->setDbValueDef($rsnew, $this->Make->CurrentValue, null, $this->Make->ReadOnly);

            // Model
            $this->Model->setDbValueDef($rsnew, $this->Model->CurrentValue, null, $this->Model->ReadOnly);

            // Year of Manufacture
            $this->YearofManufacture->setDbValueDef($rsnew, $this->YearofManufacture->CurrentValue, null, $this->YearofManufacture->ReadOnly);

            // Colour
            $this->Colour->setDbValueDef($rsnew, $this->Colour->CurrentValue, null, $this->Colour->ReadOnly);

            // Engine Number
            $this->EngineNumber->setDbValueDef($rsnew, $this->EngineNumber->CurrentValue, null, $this->EngineNumber->ReadOnly);

            // Chasis Number
            $this->ChasisNumber->setDbValueDef($rsnew, $this->ChasisNumber->CurrentValue, null, $this->ChasisNumber->ReadOnly);

            // Civilian Plate Number
            $this->CivilianPlateNumber->setDbValueDef($rsnew, $this->CivilianPlateNumber->CurrentValue, null, $this->CivilianPlateNumber->ReadOnly);

            // Govt Plate Number
            $this->GovtPlateNumber->setDbValueDef($rsnew, $this->GovtPlateNumber->CurrentValue, null, $this->GovtPlateNumber->ReadOnly);

            // Asset_No
            $this->Asset_No->setDbValueDef($rsnew, $this->Asset_No->CurrentValue, null, $this->Asset_No->ReadOnly);

            // Details_of_Asset
            $this->Details_of_Asset->setDbValueDef($rsnew, $this->Details_of_Asset->CurrentValue, "", $this->Details_of_Asset->ReadOnly);

            // Condition_Of_Asset
            $this->Condition_Of_Asset->setDbValueDef($rsnew, $this->Condition_Of_Asset->CurrentValue, "", $this->Condition_Of_Asset->ReadOnly);

            // Custodian_id
            $this->Custodian_id->setDbValueDef($rsnew, $this->Custodian_id->CurrentValue, null, $this->Custodian_id->ReadOnly);

            // Date_of_Acquisition
            $this->Date_of_Acquisition->setDbValueDef($rsnew, UnFormatDateTime($this->Date_of_Acquisition->CurrentValue, 0), CurrentDate(), $this->Date_of_Acquisition->ReadOnly);

            // Aquistion_Cost
            $this->Aquistion_Cost->setDbValueDef($rsnew, $this->Aquistion_Cost->CurrentValue, 0, $this->Aquistion_Cost->ReadOnly);

            // Additional_Cost
            $this->Additional_Cost->setDbValueDef($rsnew, $this->Additional_Cost->CurrentValue, null, $this->Additional_Cost->ReadOnly);

            // Revaluation_Cost
            $this->Revaluation_Cost->setDbValueDef($rsnew, $this->Revaluation_Cost->CurrentValue, null, $this->Revaluation_Cost->ReadOnly);

            // Remarks
            $this->Remarks->setDbValueDef($rsnew, $this->Remarks->CurrentValue, null, $this->Remarks->ReadOnly);

            // Updated_on
            $this->Updated_on->CurrentValue = CurrentDate();
            $this->Updated_on->setDbValueDef($rsnew, $this->Updated_on->CurrentValue, null);

            // Call Row Updating event
            $updateRow = $this->rowUpdating($rsold, $rsnew);
            if ($updateRow) {
                if (count($rsnew) > 0) {
                    try {
                        $editRow = $this->update($rsnew, "", $rsold);
                    } catch (\Exception $e) {
                        $this->setFailureMessage($e->getMessage());
                    }
                } else {
                    $editRow = true; // No field to update
                }
                if ($editRow) {
                }
            } else {
                if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                    // Use the message, do nothing
                } elseif ($this->CancelMessage != "") {
                    $this->setFailureMessage($this->CancelMessage);
                    $this->CancelMessage = "";
                } else {
                    $this->setFailureMessage($Language->phrase("UpdateCancelled"));
                }
                $editRow = false;
            }
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($editRow) {
        }

        // Write JSON for API request
        if (IsApi() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $editRow;
    }

    // Show link optionally based on User ID
    protected function showOptionLink($id = "")
    {
        global $Security;
        if ($Security->isLoggedIn() && !$Security->isAdmin() && !$this->userIDAllow($id)) {
            return $Security->isValidUserID($this->MDA_id->CurrentValue);
        }
        return true;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("assetstbllist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_MDA_Parent":
                    break;
                case "x_MDA_id":
                    break;
                case "x_Location_id":
                    break;
                case "x_Asset_Status":
                    break;
                case "x_Category_Temp":
                    break;
                case "x_Make":
                    break;
                case "x_Model":
                    break;
                case "x_Condition_Of_Asset":
                    break;
                case "x_Custodian_id":
                    break;
                case "x_Category":
                    break;
                case "x_Category_Details":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            $pageNo = Get(Config("TABLE_PAGE_NO"));
            if ($pageNo !== null) { // Check for "pageno" parameter first
                if (is_numeric($pageNo)) {
                    $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                    if ($this->StartRecord <= 0) {
                        $this->StartRecord = 1;
                    } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                        $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                    }
                    $this->setStartRecordNumber($this->StartRecord);
                }
            } elseif ($startRec !== null) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
