<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class DetailedReportSummary extends DetailedReport
{
    use MessagesTrait;

    // Page ID
    public $PageID = "summary";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'Detailed Report';

    // Page object name
    public $PageObjName = "DetailedReportSummary";

    // Rendering View
    public $RenderingView = false;

    // CSS
    public $ReportTableClass = "";
    public $ReportTableStyle = "";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Export URLs
    public $ExportPrintUrl;
    public $ExportHtmlUrl;
    public $ExportExcelUrl;
    public $ExportWordUrl;
    public $ExportXmlUrl;
    public $ExportCsvUrl;
    public $ExportPdfUrl;

    // Custom export
    public $ExportExcelCustom = false;
    public $ExportWordCustom = false;
    public $ExportPdfCustom = false;
    public $ExportEmailCustom = false;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (DetailedReport)
        if (!isset($GLOBALS["DetailedReport"]) || get_class($GLOBALS["DetailedReport"]) == PROJECT_NAMESPACE . "DetailedReport") {
            $GLOBALS["DetailedReport"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Initialize URLs
        $this->ExportPrintUrl = $pageUrl . "export=print";
        $this->ExportExcelUrl = $pageUrl . "export=excel";
        $this->ExportWordUrl = $pageUrl . "export=word";
        $this->ExportPdfUrl = $pageUrl . "export=pdf";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'Detailed Report');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions("div");
        $this->ExportOptions->TagClassName = "ew-export-option";

        // Filter options
        $this->FilterOptions = new ListOptions("div");
        $this->FilterOptions->TagClassName = "ew-filter-option fsummary";
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->isExport() && !$this->isExport("print")) {
            $class = PROJECT_NAMESPACE . Config("REPORT_EXPORT_CLASSES." . $this->Export);
            if (class_exists($class)) {
                $content = $this->getContents();
                $doc = new $class();
                $doc($this, $content);
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection if not in dashboard
        if (!$DashboardReport) {
            CloseConnections();
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;
        if (in_array($lookup->LinkTable, [$this->ReportSourceTable, $this->TableVar])) {
            $lookup->RenderViewFunc = "renderLookup"; // Set up view renderer
        }
        $lookup->RenderEditFunc = ""; // Set up edit renderer

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }

    // Options
    public $HideOptions = false;
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $FilterOptions; // Filter options

    // Records
    public $GroupRecords = [];
    public $DetailRecords = [];
    public $DetailRecordCount = 0;

    // Paging variables
    public $RecordIndex = 0; // Record index
    public $RecordCount = 0; // Record count (start from 1 for each group)
    public $StartGroup = 0; // Start group
    public $StopGroup = 0; // Stop group
    public $TotalGroups = 0; // Total groups
    public $GroupCount = 0; // Group count
    public $GroupCounter = []; // Group counter
    public $DisplayGroups = 10; // Groups per page
    public $GroupRange = 10;
    public $PageSizes = "1,2,3,5,10,-1"; // Page sizes (comma separated)
    public $PageFirstGroupFilter = "";
    public $UserIDFilter = "";
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = "";
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchRowCount = 0; // For extended search
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $DrillDownList = "";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $SearchCommand = false;
    public $ShowHeader;
    public $GroupColumnCount = 0;
    public $SubGroupColumnCount = 0;
    public $DetailColumnCount = 0;
    public $TotalCount;
    public $PageTotalCount;
    public $TopContentClass = "col-sm-12 ew-top";
    public $LeftContentClass = "ew-left";
    public $CenterContentClass = "col-sm-12 ew-center";
    public $RightContentClass = "ew-right";
    public $BottomContentClass = "col-sm-12 ew-bottom";

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $ExportFileName, $Language, $Security, $UserProfile,
            $Security, $DrillDownInPanel, $Breadcrumb,
            $DashboardReport, $CustomExportType, $ReportExportType;

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        }
        $ExportFileName = $this->TableVar; // Get export file, used in header

        // Get custom export parameters
        if ($this->isExport() && $custom != "") {
            $this->CustomExport = $this->Export;
            $this->Export = "print";
        }
        $CustomExportType = $this->CustomExport;
        $ExportType = $this->Export; // Get export parameter, used in header
        $ReportExportType = $ExportType; // Report export type, used in header

        // Update Export URLs
        if ($this->ExportExcelCustom) {
            $this->ExportExcelUrl .= "&amp;custom=1";
        }
        if ($this->ExportWordCustom) {
            $this->ExportWordUrl .= "&amp;custom=1";
        }
        if ($this->ExportPdfCustom) {
            $this->ExportPdfUrl .= "&amp;custom=1";
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Setup export options
        $this->setupExportOptions();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up table class
        if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf")) {
            $this->ReportTableClass = "ew-table";
        } else {
            $this->ReportTableClass = "table ew-table";
        }

        // Set field visibility for detail fields
        $this->_23->setVisibility();
        $this->Assetsid->setVisibility();
        $this->MDA_Parent->setVisibility();
        $this->MDA_id->setVisibility();
        $this->Location_id->setVisibility();
        $this->Details_of_Asset->setVisibility();
        $this->Asset_Status->setVisibility();
        $this->Condition_Of_Asset->setVisibility();
        $this->Custodian_id->setVisibility();
        $this->Category->setVisibility();
        $this->Category_Details->setVisibility();
        $this->Date_of_Acquisition->setVisibility();
        $this->Aquistion_Cost->setVisibility();
        $this->Additional_Cost->setVisibility();
        $this->Revaluation_Cost->setVisibility();

        // Set up User ID
        $filter = "";
        $filter = $this->applyUserIDFilters($filter);
        $this->UserIDFilter = $filter;
        $this->Filter = $this->UserIDFilter;

        // Set up groups per page dynamically
        $this->setupDisplayGroups();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Check if search command
        $this->SearchCommand = (Get("cmd", "") == "search");

        // Load custom filters
        $this->pageFilterLoad();

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }

        // Extended filter
        $extendedFilter = "";

        // Restore filter list
        $this->restoreFilterList();

        // Build extended filter
        $extendedFilter = $this->getExtendedFilter();
        AddFilter($this->SearchWhere, $extendedFilter);

        // Call Page Selecting event
        $this->pageSelecting($this->SearchWhere);

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Get sort
        $this->Sort = $this->getSort();

        // Search options
        $this->setupSearchOptions();

        // Update filter
        AddFilter($this->Filter, $this->SearchWhere);

        // Get total count
        $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
        $this->TotalGroups = $this->getRecordCount($sql);
        if ($this->DisplayGroups <= 0 || $this->DrillDown || $DashboardReport) { // Display all groups
            $this->DisplayGroups = $this->TotalGroups;
        }
        $this->StartGroup = 1;

        // Show header
        $this->ShowHeader = ($this->TotalGroups > 0);

        // Set up start position if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->DisplayGroups = $this->TotalGroups;
        } else {
            $this->setupStartGroup();
        }

        // Set no record found message
        if ($this->TotalGroups == 0) {
            if ($Security->canList()) {
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            } else {
                $this->setWarningMessage(DeniedMessage());
            }
        }

        // Hide export options if export/dashboard report/hide options
        if ($this->isExport() || $DashboardReport || $this->HideOptions) {
            $this->ExportOptions->hideAllOptions();
        }

        // Hide search/filter options if export/drilldown/dashboard report/hide options
        if ($this->isExport() || $this->DrillDown || $DashboardReport || $this->HideOptions) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }

        // Get current page records
        if ($this->TotalGroups > 0) {
            $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, $this->Sort);
            $rs = $sql->setFirstResult($this->StartGroup - 1)->setMaxResults($this->DisplayGroups)->execute();
            $this->DetailRecords = $rs->fetchAll(); // Get records
            $this->GroupCount = 1;
        }
        $this->setupFieldCount();

        // Set the last group to display if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->StopGroup = $this->TotalGroups;
        } else {
            $this->StopGroup = $this->StartGroup + $this->DisplayGroups - 1;
        }

        // Stop group <= total number of groups
        if (intval($this->StopGroup) > intval($this->TotalGroups)) {
            $this->StopGroup = $this->TotalGroups;
        }
        $this->RecordCount = 0;
        $this->RecordIndex = 0;
        $this->setGroupCount($this->StopGroup - $this->StartGroup + 1, 1);

        // Set up pager
        $this->Pager = new PrevNextPager($this->StartGroup, $this->getGroupPerPage(), $this->TotalGroups, $this->PageSizes, $this->GroupRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Load row values
    public function loadRowValues($record)
    {
        $data = [];
        $data["_23"] = $record['#'];
        $data["Assetsid"] = $record['Assetsid'];
        $data["MDA_Parent"] = $record['MDA_Parent'];
        $data["MDA_id"] = $record['MDA_id'];
        $data["Location_id"] = $record['Location_id'];
        $data["Asset_No"] = $record['Asset_No'];
        $data["Details_of_Asset"] = $record['Details_of_Asset'];
        $data["Asset_Status"] = $record['Asset_Status'];
        $data["Condition_Of_Asset"] = $record['Condition_Of_Asset'];
        $data["Custodian_id"] = $record['Custodian_id'];
        $data["Category"] = $record['Category'];
        $data["Category_Details"] = $record['Category_Details'];
        $data["Category_Temp"] = $record['Category_Temp'];
        $data["Date_of_Acquisition"] = $record['Date_of_Acquisition'];
        $data["Aquistion_Cost"] = $record['Aquistion_Cost'];
        $data["Additional_Cost"] = $record['Additional_Cost'];
        $data["Revaluation_Cost"] = $record['Revaluation_Cost'];
        $data["Created_By"] = $record['Created_By'];
        $data["Created_on"] = $record['Created_on'];
        $data["Updated_on"] = $record['Updated_on'];
        $this->Rows[] = $data;
        $this->_23->setDbValue($record['#']);
        $this->Assetsid->setDbValue($record['Assetsid']);
        $this->MDA_Parent->setDbValue($record['MDA_Parent']);
        $this->MDA_id->setDbValue($record['MDA_id']);
        $this->Location_id->setDbValue($record['Location_id']);
        $this->Asset_No->setDbValue($record['Asset_No']);
        $this->Details_of_Asset->setDbValue($record['Details_of_Asset']);
        $this->Asset_Status->setDbValue($record['Asset_Status']);
        $this->Condition_Of_Asset->setDbValue($record['Condition_Of_Asset']);
        $this->Custodian_id->setDbValue($record['Custodian_id']);
        $this->Category->setDbValue($record['Category']);
        $this->Category_Details->setDbValue($record['Category_Details']);
        $this->Category_Temp->setDbValue($record['Category_Temp']);
        $this->Date_of_Acquisition->setDbValue($record['Date_of_Acquisition']);
        $this->Aquistion_Cost->setDbValue($record['Aquistion_Cost']);
        $this->Additional_Cost->setDbValue($record['Additional_Cost']);
        $this->Revaluation_Cost->setDbValue($record['Revaluation_Cost']);
        $this->Remarks->setDbValue($record['Remarks']);
        $this->Created_By->setDbValue($record['Created_By']);
        $this->Created_on->setDbValue($record['Created_on']);
        $this->Updated_on->setDbValue($record['Updated_on']);
    }

    // Render row
    public function renderRow()
    {
        global $Security, $Language, $Language;
        $conn = $this->getConnection();
        if ($this->RowType == ROWTYPE_TOTAL && $this->RowTotalSubType == ROWTOTAL_FOOTER && $this->RowTotalType == ROWTOTAL_PAGE) { // Get Page total
            $records = &$this->DetailRecords;
            $this->Aquistion_Cost->getSum($records);
            $this->Additional_Cost->getSum($records);
            $this->Revaluation_Cost->getSum($records);
            $this->PageTotalCount = count($records);
        } elseif ($this->RowType == ROWTYPE_TOTAL && $this->RowTotalSubType == ROWTOTAL_FOOTER && $this->RowTotalType == ROWTOTAL_GRAND) { // Get Grand total
            $hasCount = false;
            $hasSummary = false;

            // Get total count from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectCount(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $rstot = $conn->executeQuery($sql);
            if ($rstot && $cnt = $rstot->fetchColumn()) {
                $rstot->closeCursor();
                $hasCount = true;
            } else {
                $cnt = 0;
            }
            $this->TotalCount = $cnt;

            // Get total from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectAggregate(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $sql = $this->getSqlAggregatePrefix() . $sql . $this->getSqlAggregateSuffix();
            $rsagg = $conn->fetchAssoc($sql);
            if ($rsagg) {
                $this->_23->Count = $this->TotalCount;
                $this->Assetsid->Count = $this->TotalCount;
                $this->MDA_Parent->Count = $this->TotalCount;
                $this->MDA_id->Count = $this->TotalCount;
                $this->Location_id->Count = $this->TotalCount;
                $this->Details_of_Asset->Count = $this->TotalCount;
                $this->Asset_Status->Count = $this->TotalCount;
                $this->Condition_Of_Asset->Count = $this->TotalCount;
                $this->Custodian_id->Count = $this->TotalCount;
                $this->Category->Count = $this->TotalCount;
                $this->Category_Details->Count = $this->TotalCount;
                $this->Date_of_Acquisition->Count = $this->TotalCount;
                $this->Aquistion_Cost->Count = $this->TotalCount;
                $this->Aquistion_Cost->SumValue = $rsagg["sum_aquistion_cost"];
                $this->Additional_Cost->Count = $this->TotalCount;
                $this->Additional_Cost->SumValue = $rsagg["sum_additional_cost"];
                $this->Revaluation_Cost->Count = $this->TotalCount;
                $this->Revaluation_Cost->SumValue = $rsagg["sum_revaluation_cost"];
                $hasSummary = true;
            }

            // Accumulate grand summary from detail records
            if (!$hasCount || !$hasSummary) {
                $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
                $rs = $sql->execute();
                $this->DetailRecords = $rs ? $rs->fetchAll() : [];
                $this->Aquistion_Cost->getSum($this->DetailRecords);
                $this->Additional_Cost->getSum($this->DetailRecords);
                $this->Revaluation_Cost->getSum($this->DetailRecords);
            }
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // #

        // Assetsid

        // MDA_Parent

        // MDA_id

        // Location_id

        // Details_of_Asset

        // Asset_Status

        // Condition_Of_Asset

        // Custodian_id

        // Category

        // Category_Details

        // Date_of_Acquisition

        // Aquistion_Cost

        // Additional_Cost

        // Revaluation_Cost
        if ($this->RowType == ROWTYPE_SEARCH) {
            // MDA_Parent
            $this->MDA_Parent->EditAttrs["class"] = "form-control";
            $this->MDA_Parent->EditCustomAttributes = "";
            $curVal = $this->MDA_Parent->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->MDA_Parent->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->MDA_Parent->AdvancedSearch->ViewValue = $this->MDA_Parent->lookupCacheOption($curVal);
            } else {
                $this->MDA_Parent->AdvancedSearch->ViewValue = $this->MDA_Parent->Lookup !== null && is_array($this->MDA_Parent->Lookup->Options) ? $curVal : null;
            }
            if ($this->MDA_Parent->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->MDA_Parent->EditValue = array_values($this->MDA_Parent->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Parent`" . SearchString("=", $this->MDA_Parent->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->MDA_Parent->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->MDA_Parent->EditValue = $arwrk;
            }
            $this->MDA_Parent->PlaceHolder = RemoveHtml($this->MDA_Parent->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("summary")) { // Non system admin
                $this->MDA_id->AdvancedSearch->SearchValue = CurrentUserID();
                $this->MDA_id->EditValue = $this->MDA_id->AdvancedSearch->SearchValue;
                $curVal = $this->MDA_id->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->MDA_id->AdvancedSearch->SearchValue));
                if ($curVal != "") {
                    $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                    if ($this->MDA_id->EditValue === null) { // Lookup from database
                        $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                        $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                            $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                        } else {
                            $this->MDA_id->EditValue = $this->MDA_id->AdvancedSearch->SearchValue;
                        }
                    }
                } else {
                    $this->MDA_id->EditValue = null;
                }
                $this->MDA_id->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
                $this->MDA_id->ViewCustomAttributes = "";
            } else {
                $curVal = $this->MDA_id->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->MDA_id->AdvancedSearch->SearchValue));
                if ($curVal != "") {
                    $this->MDA_id->AdvancedSearch->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                } else {
                    $this->MDA_id->AdvancedSearch->ViewValue = $this->MDA_id->Lookup !== null && is_array($this->MDA_id->Lookup->Options) ? $curVal : null;
                }
                if ($this->MDA_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                    $this->MDA_id->EditValue = array_values($this->MDA_id->Lookup->Options);
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = "`MDAID`" . SearchString("=", $this->MDA_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->MDA_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->MDA_id->EditValue = $arwrk;
                }
                $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
            }

            // Location_id
            $this->Location_id->EditAttrs["class"] = "form-control";
            $this->Location_id->EditCustomAttributes = "";
            $curVal = $this->Location_id->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->Location_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Location_id->AdvancedSearch->ViewValue = $this->Location_id->lookupCacheOption($curVal);
            } else {
                $this->Location_id->AdvancedSearch->ViewValue = $this->Location_id->Lookup !== null && is_array($this->Location_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Location_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Location_id->EditValue = array_values($this->Location_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Locationid`" . SearchString("=", $this->Location_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Location_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Location_id->EditValue = $arwrk;
            }
            $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

            // Asset_Status
            $this->Asset_Status->EditAttrs["class"] = "form-control";
            $this->Asset_Status->EditCustomAttributes = "";
            $curVal = $this->Asset_Status->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->Asset_Status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Asset_Status->AdvancedSearch->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
            } else {
                $this->Asset_Status->AdvancedSearch->ViewValue = $this->Asset_Status->Lookup !== null && is_array($this->Asset_Status->Lookup->Options) ? $curVal : null;
            }
            if ($this->Asset_Status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Asset_Status->EditValue = array_values($this->Asset_Status->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Status`" . SearchString("=", $this->Asset_Status->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Asset_Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Asset_Status->EditValue = $arwrk;
            }
            $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

            // Condition_Of_Asset
            $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
            $this->Condition_Of_Asset->EditCustomAttributes = "";
            $curVal = $this->Condition_Of_Asset->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->Condition_Of_Asset->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->AdvancedSearch->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
            } else {
                $this->Condition_Of_Asset->AdvancedSearch->ViewValue = $this->Condition_Of_Asset->Lookup !== null && is_array($this->Condition_Of_Asset->Lookup->Options) ? $curVal : null;
            }
            if ($this->Condition_Of_Asset->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Condition_Of_Asset->EditValue = array_values($this->Condition_Of_Asset->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`status`" . SearchString("=", $this->Condition_Of_Asset->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Condition_Of_Asset->EditValue = $arwrk;
            }
            $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

            // Custodian_id
            $this->Custodian_id->EditAttrs["class"] = "form-control";
            $this->Custodian_id->EditCustomAttributes = "";
            $curVal = $this->Custodian_id->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->Custodian_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Custodian_id->AdvancedSearch->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
            } else {
                $this->Custodian_id->AdvancedSearch->ViewValue = $this->Custodian_id->Lookup !== null && is_array($this->Custodian_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Custodian_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Custodian_id->EditValue = array_values($this->Custodian_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`id`" . SearchString("=", $this->Custodian_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Custodian_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Custodian_id->EditValue = $arwrk;
            }
            $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

            // Category
            $this->Category->EditCustomAttributes = "";
            $curVal = $this->Category->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->Category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Category->AdvancedSearch->ViewValue = $this->Category->lookupCacheOption($curVal);
            } else {
                $this->Category->AdvancedSearch->ViewValue = $this->Category->Lookup !== null && is_array($this->Category->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Category->EditValue = array_values($this->Category->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                }
                $sqlWrk = $this->Category->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category->EditValue = $arwrk;
            }
            $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

            // Category_Details
            $this->Category_Details->EditAttrs["class"] = "form-control";
            $this->Category_Details->EditCustomAttributes = "";
            $curVal = $this->Category_Details->AdvancedSearch->SearchValue == INIT_VALUE ? "" : trim(strval($this->Category_Details->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Category_Details->AdvancedSearch->ViewValue = $this->Category_Details->lookupCacheOption($curVal);
            } else {
                $this->Category_Details->AdvancedSearch->ViewValue = $this->Category_Details->Lookup !== null && is_array($this->Category_Details->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category_Details->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Category_Details->EditValue = array_values($this->Category_Details->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Category_Details`" . SearchString("=", $this->Category_Details->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Category_Details->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category_Details->EditValue = $arwrk;
            }
            $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

            // Date_of_Acquisition
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Date_of_Acquisition->AdvancedSearch->SearchValue, 0), 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Date_of_Acquisition->AdvancedSearch->SearchValue2, 0), 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

            // Aquistion_Cost
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue = HtmlEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue2 = HtmlEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue2);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());
        } elseif ($this->RowType == ROWTYPE_TOTAL && !($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER)) { // Summary row
            $this->RowAttrs->prependClass(($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class

            // Aquistion_Cost
            $this->Aquistion_Cost->SumViewValue = $this->Aquistion_Cost->SumValue;
            $this->Aquistion_Cost->SumViewValue = FormatNumber($this->Aquistion_Cost->SumViewValue, 2, -2, -2, -2);
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";
            $this->Aquistion_Cost->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

            // Additional_Cost
            $this->Additional_Cost->SumViewValue = $this->Additional_Cost->SumValue;
            $this->Additional_Cost->SumViewValue = FormatNumber($this->Additional_Cost->SumViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";
            $this->Additional_Cost->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

            // Revaluation_Cost
            $this->Revaluation_Cost->SumViewValue = $this->Revaluation_Cost->SumValue;
            $this->Revaluation_Cost->SumViewValue = FormatNumber($this->Revaluation_Cost->SumViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";
            $this->Revaluation_Cost->CellAttrs["class"] = ($this->RowTotalType == ROWTOTAL_PAGE || $this->RowTotalType == ROWTOTAL_GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

            // #
            $this->_23->HrefValue = "";

            // Assetsid
            $this->Assetsid->HrefValue = "";

            // MDA_Parent
            $this->MDA_Parent->HrefValue = "";

            // MDA_id
            $this->MDA_id->HrefValue = "";

            // Location_id
            $this->Location_id->HrefValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->HrefValue = "";

            // Asset_Status
            $this->Asset_Status->HrefValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->HrefValue = "";

            // Custodian_id
            $this->Custodian_id->HrefValue = "";

            // Category
            $this->Category->HrefValue = "";

            // Category_Details
            $this->Category_Details->HrefValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->HrefValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->HrefValue = "";

            // Additional_Cost
            $this->Additional_Cost->HrefValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->HrefValue = "";
        } else {
            if ($this->RowTotalType == ROWTOTAL_GROUP && $this->RowTotalSubType == ROWTOTAL_HEADER) {
            } else {
            }

            // #
            $this->_23->ViewValue = $this->_23->CurrentValue;
            $this->_23->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->_23->CellCssStyle .= "text-align: right;";
            $this->_23->ViewCustomAttributes = "";

            // Assetsid
            $this->Assetsid->ViewValue = $this->Assetsid->CurrentValue;
            $this->Assetsid->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Assetsid->ViewCustomAttributes = "";

            // MDA_Parent
            $this->MDA_Parent->ViewValue = $this->MDA_Parent->CurrentValue;
            $curVal = $this->MDA_Parent->CurrentValue == INIT_VALUE ? "" : trim(strval($this->MDA_Parent->CurrentValue));
            if ($curVal != "") {
                $this->MDA_Parent->ViewValue = $this->MDA_Parent->lookupCacheOption($curVal);
                if ($this->MDA_Parent->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Parent`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->MDA_Parent->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_Parent->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_Parent->ViewValue = $this->MDA_Parent->displayValue($arwrk);
                    } else {
                        $this->MDA_Parent->ViewValue = $this->MDA_Parent->CurrentValue;
                    }
                }
            } else {
                $this->MDA_Parent->ViewValue = null;
            }
            $this->MDA_Parent->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->MDA_Parent->ViewCustomAttributes = "";

            // MDA_id
            $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
            $curVal = $this->MDA_id->CurrentValue == INIT_VALUE ? "" : trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->ViewValue = null;
            }
            $this->MDA_id->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->MDA_id->ViewCustomAttributes = "";

            // Location_id
            $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
            $curVal = $this->Location_id->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
                if ($this->Location_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                    } else {
                        $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                    }
                }
            } else {
                $this->Location_id->ViewValue = null;
            }
            $this->Location_id->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Location_id->ViewCustomAttributes = "";

            // Details_of_Asset
            $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
            $this->Details_of_Asset->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Details_of_Asset->ViewCustomAttributes = "";

            // Asset_Status
            $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
            $curVal = $this->Asset_Status->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Asset_Status->CurrentValue));
            if ($curVal != "") {
                $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
                if ($this->Asset_Status->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Asset_Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Asset_Status->Lookup->renderViewRow($rswrk[0]);
                        $this->Asset_Status->ViewValue = $this->Asset_Status->displayValue($arwrk);
                    } else {
                        $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
                    }
                }
            } else {
                $this->Asset_Status->ViewValue = null;
            }
            $this->Asset_Status->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Asset_Status->ViewCustomAttributes = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
            $curVal = $this->Condition_Of_Asset->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Condition_Of_Asset->CurrentValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
                if ($this->Condition_Of_Asset->ViewValue === null) { // Lookup from database
                    $filterWrk = "`status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Condition_Of_Asset->Lookup->renderViewRow($rswrk[0]);
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->displayValue($arwrk);
                    } else {
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
                    }
                }
            } else {
                $this->Condition_Of_Asset->ViewValue = null;
            }
            $this->Condition_Of_Asset->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Condition_Of_Asset->ViewCustomAttributes = "";

            // Custodian_id
            $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
            $curVal = $this->Custodian_id->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
                if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Custodian_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Custodian_id->ViewValue = $this->Custodian_id->displayValue($arwrk);
                    } else {
                        $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                    }
                }
            } else {
                $this->Custodian_id->ViewValue = null;
            }
            $this->Custodian_id->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Custodian_id->ViewCustomAttributes = "";

            // Category
            $this->Category->ViewValue = $this->Category->CurrentValue;
            $curVal = $this->Category->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Category->CurrentValue));
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->Category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->Category->Lookup->renderViewRow($row);
                            $this->Category->ViewValue->add($this->Category->displayValue($arwrk));
                        }
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }
            $this->Category->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Category->ViewCustomAttributes = "";

            // Category_Details
            $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
            $curVal = $this->Category_Details->CurrentValue == INIT_VALUE ? "" : trim(strval($this->Category_Details->CurrentValue));
            if ($curVal != "") {
                $this->Category_Details->ViewValue = $this->Category_Details->lookupCacheOption($curVal);
                if ($this->Category_Details->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Category_Details`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Category_Details->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category_Details->Lookup->renderViewRow($rswrk[0]);
                        $this->Category_Details->ViewValue = $this->Category_Details->displayValue($arwrk);
                    } else {
                        $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
                    }
                }
            } else {
                $this->Category_Details->ViewValue = null;
            }
            $this->Category_Details->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Category_Details->ViewCustomAttributes = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
            $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
            $this->Date_of_Acquisition->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Date_of_Acquisition->ViewCustomAttributes = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -2, -2);
            $this->Aquistion_Cost->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";

            // Additional_Cost
            $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "ew-table-row");
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";

            // #
            $this->_23->LinkCustomAttributes = "";
            $this->_23->HrefValue = "";
            $this->_23->TooltipValue = "";

            // Assetsid
            $this->Assetsid->LinkCustomAttributes = "";
            $this->Assetsid->HrefValue = "";
            $this->Assetsid->TooltipValue = "";

            // MDA_Parent
            $this->MDA_Parent->LinkCustomAttributes = "";
            $this->MDA_Parent->HrefValue = "";
            $this->MDA_Parent->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";
            $this->Location_id->TooltipValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";
            $this->Details_of_Asset->TooltipValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";
            $this->Asset_Status->TooltipValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";
            $this->Condition_Of_Asset->TooltipValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";
            $this->Custodian_id->TooltipValue = "";

            // Category
            $this->Category->LinkCustomAttributes = "";
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";
            $this->Category_Details->TooltipValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";
            $this->Date_of_Acquisition->TooltipValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";
            $this->Aquistion_Cost->TooltipValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";
            $this->Additional_Cost->TooltipValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";
            $this->Revaluation_Cost->TooltipValue = "";
        }

        // Call Cell_Rendered event
        if ($this->RowType == ROWTYPE_TOTAL) {
            // Aquistion_Cost
            $currentValue = $this->Aquistion_Cost->SumValue;
            $viewValue = &$this->Aquistion_Cost->SumViewValue;
            $viewAttrs = &$this->Aquistion_Cost->ViewAttrs;
            $cellAttrs = &$this->Aquistion_Cost->CellAttrs;
            $hrefValue = &$this->Aquistion_Cost->HrefValue;
            $linkAttrs = &$this->Aquistion_Cost->LinkAttrs;
            $this->cellRendered($this->Aquistion_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Additional_Cost
            $currentValue = $this->Additional_Cost->SumValue;
            $viewValue = &$this->Additional_Cost->SumViewValue;
            $viewAttrs = &$this->Additional_Cost->ViewAttrs;
            $cellAttrs = &$this->Additional_Cost->CellAttrs;
            $hrefValue = &$this->Additional_Cost->HrefValue;
            $linkAttrs = &$this->Additional_Cost->LinkAttrs;
            $this->cellRendered($this->Additional_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Revaluation_Cost
            $currentValue = $this->Revaluation_Cost->SumValue;
            $viewValue = &$this->Revaluation_Cost->SumViewValue;
            $viewAttrs = &$this->Revaluation_Cost->ViewAttrs;
            $cellAttrs = &$this->Revaluation_Cost->CellAttrs;
            $hrefValue = &$this->Revaluation_Cost->HrefValue;
            $linkAttrs = &$this->Revaluation_Cost->LinkAttrs;
            $this->cellRendered($this->Revaluation_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        } else {
            // #
            $currentValue = $this->_23->CurrentValue;
            $viewValue = &$this->_23->ViewValue;
            $viewAttrs = &$this->_23->ViewAttrs;
            $cellAttrs = &$this->_23->CellAttrs;
            $hrefValue = &$this->_23->HrefValue;
            $linkAttrs = &$this->_23->LinkAttrs;
            $this->cellRendered($this->_23, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Assetsid
            $currentValue = $this->Assetsid->CurrentValue;
            $viewValue = &$this->Assetsid->ViewValue;
            $viewAttrs = &$this->Assetsid->ViewAttrs;
            $cellAttrs = &$this->Assetsid->CellAttrs;
            $hrefValue = &$this->Assetsid->HrefValue;
            $linkAttrs = &$this->Assetsid->LinkAttrs;
            $this->cellRendered($this->Assetsid, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // MDA_Parent
            $currentValue = $this->MDA_Parent->CurrentValue;
            $viewValue = &$this->MDA_Parent->ViewValue;
            $viewAttrs = &$this->MDA_Parent->ViewAttrs;
            $cellAttrs = &$this->MDA_Parent->CellAttrs;
            $hrefValue = &$this->MDA_Parent->HrefValue;
            $linkAttrs = &$this->MDA_Parent->LinkAttrs;
            $this->cellRendered($this->MDA_Parent, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // MDA_id
            $currentValue = $this->MDA_id->CurrentValue;
            $viewValue = &$this->MDA_id->ViewValue;
            $viewAttrs = &$this->MDA_id->ViewAttrs;
            $cellAttrs = &$this->MDA_id->CellAttrs;
            $hrefValue = &$this->MDA_id->HrefValue;
            $linkAttrs = &$this->MDA_id->LinkAttrs;
            $this->cellRendered($this->MDA_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Location_id
            $currentValue = $this->Location_id->CurrentValue;
            $viewValue = &$this->Location_id->ViewValue;
            $viewAttrs = &$this->Location_id->ViewAttrs;
            $cellAttrs = &$this->Location_id->CellAttrs;
            $hrefValue = &$this->Location_id->HrefValue;
            $linkAttrs = &$this->Location_id->LinkAttrs;
            $this->cellRendered($this->Location_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Details_of_Asset
            $currentValue = $this->Details_of_Asset->CurrentValue;
            $viewValue = &$this->Details_of_Asset->ViewValue;
            $viewAttrs = &$this->Details_of_Asset->ViewAttrs;
            $cellAttrs = &$this->Details_of_Asset->CellAttrs;
            $hrefValue = &$this->Details_of_Asset->HrefValue;
            $linkAttrs = &$this->Details_of_Asset->LinkAttrs;
            $this->cellRendered($this->Details_of_Asset, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Asset_Status
            $currentValue = $this->Asset_Status->CurrentValue;
            $viewValue = &$this->Asset_Status->ViewValue;
            $viewAttrs = &$this->Asset_Status->ViewAttrs;
            $cellAttrs = &$this->Asset_Status->CellAttrs;
            $hrefValue = &$this->Asset_Status->HrefValue;
            $linkAttrs = &$this->Asset_Status->LinkAttrs;
            $this->cellRendered($this->Asset_Status, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Condition_Of_Asset
            $currentValue = $this->Condition_Of_Asset->CurrentValue;
            $viewValue = &$this->Condition_Of_Asset->ViewValue;
            $viewAttrs = &$this->Condition_Of_Asset->ViewAttrs;
            $cellAttrs = &$this->Condition_Of_Asset->CellAttrs;
            $hrefValue = &$this->Condition_Of_Asset->HrefValue;
            $linkAttrs = &$this->Condition_Of_Asset->LinkAttrs;
            $this->cellRendered($this->Condition_Of_Asset, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Custodian_id
            $currentValue = $this->Custodian_id->CurrentValue;
            $viewValue = &$this->Custodian_id->ViewValue;
            $viewAttrs = &$this->Custodian_id->ViewAttrs;
            $cellAttrs = &$this->Custodian_id->CellAttrs;
            $hrefValue = &$this->Custodian_id->HrefValue;
            $linkAttrs = &$this->Custodian_id->LinkAttrs;
            $this->cellRendered($this->Custodian_id, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Category
            $currentValue = $this->Category->CurrentValue;
            $viewValue = &$this->Category->ViewValue;
            $viewAttrs = &$this->Category->ViewAttrs;
            $cellAttrs = &$this->Category->CellAttrs;
            $hrefValue = &$this->Category->HrefValue;
            $linkAttrs = &$this->Category->LinkAttrs;
            $this->cellRendered($this->Category, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Category_Details
            $currentValue = $this->Category_Details->CurrentValue;
            $viewValue = &$this->Category_Details->ViewValue;
            $viewAttrs = &$this->Category_Details->ViewAttrs;
            $cellAttrs = &$this->Category_Details->CellAttrs;
            $hrefValue = &$this->Category_Details->HrefValue;
            $linkAttrs = &$this->Category_Details->LinkAttrs;
            $this->cellRendered($this->Category_Details, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Date_of_Acquisition
            $currentValue = $this->Date_of_Acquisition->CurrentValue;
            $viewValue = &$this->Date_of_Acquisition->ViewValue;
            $viewAttrs = &$this->Date_of_Acquisition->ViewAttrs;
            $cellAttrs = &$this->Date_of_Acquisition->CellAttrs;
            $hrefValue = &$this->Date_of_Acquisition->HrefValue;
            $linkAttrs = &$this->Date_of_Acquisition->LinkAttrs;
            $this->cellRendered($this->Date_of_Acquisition, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Aquistion_Cost
            $currentValue = $this->Aquistion_Cost->CurrentValue;
            $viewValue = &$this->Aquistion_Cost->ViewValue;
            $viewAttrs = &$this->Aquistion_Cost->ViewAttrs;
            $cellAttrs = &$this->Aquistion_Cost->CellAttrs;
            $hrefValue = &$this->Aquistion_Cost->HrefValue;
            $linkAttrs = &$this->Aquistion_Cost->LinkAttrs;
            $this->cellRendered($this->Aquistion_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Additional_Cost
            $currentValue = $this->Additional_Cost->CurrentValue;
            $viewValue = &$this->Additional_Cost->ViewValue;
            $viewAttrs = &$this->Additional_Cost->ViewAttrs;
            $cellAttrs = &$this->Additional_Cost->CellAttrs;
            $hrefValue = &$this->Additional_Cost->HrefValue;
            $linkAttrs = &$this->Additional_Cost->LinkAttrs;
            $this->cellRendered($this->Additional_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Revaluation_Cost
            $currentValue = $this->Revaluation_Cost->CurrentValue;
            $viewValue = &$this->Revaluation_Cost->ViewValue;
            $viewAttrs = &$this->Revaluation_Cost->ViewAttrs;
            $cellAttrs = &$this->Revaluation_Cost->CellAttrs;
            $hrefValue = &$this->Revaluation_Cost->HrefValue;
            $linkAttrs = &$this->Revaluation_Cost->LinkAttrs;
            $this->cellRendered($this->Revaluation_Cost, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        }

        // Call Row_Rendered event
        $this->rowRendered();
        $this->setupFieldCount();
    }
    private $groupCounts = [];

    // Get group count
    public function getGroupCount(...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return -1;
        } elseif ($key == "0") { // Number of first level groups
            $i = 1;
            while (isset($this->groupCounts[strval($i)])) {
                $i++;
            }
            return $i - 1;
        }
        return isset($this->groupCounts[$key]) ? $this->groupCounts[$key] : -1;
    }

    // Set group count
    public function setGroupCount($value, ...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return;
        }
        $this->groupCounts[$key] = $value;
    }

    // Setup field count
    protected function setupFieldCount()
    {
        $this->GroupColumnCount = 0;
        $this->SubGroupColumnCount = 0;
        $this->DetailColumnCount = 0;
        if ($this->_23->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Assetsid->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->MDA_Parent->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->MDA_id->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Location_id->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Details_of_Asset->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Asset_Status->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Condition_Of_Asset->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Custodian_id->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Category->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Category_Details->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Date_of_Acquisition->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Aquistion_Cost->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Additional_Cost->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Revaluation_Cost->Visible) {
            $this->DetailColumnCount += 1;
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        $pageUrl = $this->pageUrl();
        if (SameText($type, "excel")) {
            return '<a class="ew-export-link ew-excel" title="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" href="#" onclick="return ew.exportWithCharts(event, \'' . $this->ExportExcelUrl . '\', \'' . session_id() . '\');">' . $Language->phrase("ExportToExcel") . '</a>';
        } elseif (SameText($type, "word")) {
            return '<a class="ew-export-link ew-word" title="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" href="#" onclick="return ew.exportWithCharts(event, \'' . $this->ExportWordUrl . '\', \'' . session_id() . '\');">' . $Language->phrase("ExportToWord") . '</a>';
        } elseif (SameText($type, "pdf")) {
            return '<a class="ew-export-link ew-pdf" title="' . HtmlEncode($Language->phrase("ExportToPDF", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToPDF", true)) . '" href="#" onclick="return ew.exportWithCharts(event, \'' . $this->ExportPdfUrl . '\', \'' . session_id() . '\');">' . $Language->phrase("ExportToPDF") . '</a>';
        } elseif (SameText($type, "email")) {
            $url = $pageUrl . "export=email" . ($custom ? "&amp;custom=1" : "");
            return '<a class="ew-export-link ew-email" title="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" id="emf_DetailedReport" href="#" onclick="return ew.emailDialogShow({ lnk: \'emf_DetailedReport\', hdr: ew.language.phrase(\'ExportToEmailText\'), url: \'' . $url . '\', exportid: \'' . session_id() . '\', el: this });">' . $Language->phrase("ExportToEmail") . '</a>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to Pdf
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = true;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl();
        $this->SearchOptions = new ListOptions("div");
        $this->SearchOptions->TagClassName = "ew-search-option";

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fsummary\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        $item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction) {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
        $Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_MDA_Parent":
                    break;
                case "x_MDA_id":
                    break;
                case "x_Location_id":
                    break;
                case "x_Asset_Status":
                    break;
                case "x_Condition_Of_Asset":
                    break;
                case "x_Custodian_id":
                    break;
                case "x_Category":
                    break;
                case "x_Category_Details":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fsummary\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fsummary\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up starting group
    protected function setupStartGroup()
    {
        // Exit if no groups
        if ($this->DisplayGroups == 0) {
            return;
        }
        $startGrp = Param(Config("TABLE_START_GROUP"), "");
        $pageNo = Param("pageno", "");

        // Check for a 'start' parameter
        if ($startGrp != "") {
            $this->StartGroup = $startGrp;
            $this->setStartGroup($this->StartGroup);
        } elseif ($pageNo != "") {
            if (is_numeric($pageNo)) {
                $this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
                if ($this->StartGroup <= 0) {
                    $this->StartGroup = 1;
                } elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
                    $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
                }
                $this->setStartGroup($this->StartGroup);
            } else {
                $this->StartGroup = $this->getStartGroup();
            }
        } else {
            $this->StartGroup = $this->getStartGroup();
        }

        // Check if correct start group counter
        if (!is_numeric($this->StartGroup) || $this->StartGroup == "") { // Avoid invalid start group counter
            $this->StartGroup = 1; // Reset start group counter
            $this->setStartGroup($this->StartGroup);
        } elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
            $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
            $this->setStartGroup($this->StartGroup);
        } elseif (($this->StartGroup - 1) % $this->DisplayGroups != 0) {
            $this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
            $this->setStartGroup($this->StartGroup);
        }
    }

    // Reset pager
    protected function resetPager()
    {
        // Reset start position (reset command)
        $this->StartGroup = 1;
        $this->setStartGroup($this->StartGroup);
    }

    // Set up number of groups displayed per page
    protected function setupDisplayGroups()
    {
        $this->DisplayGroups = 10; // Load default
        if (Param(Config("TABLE_GROUP_PER_PAGE")) !== null) {
            $wrk = Param(Config("TABLE_GROUP_PER_PAGE"));
            if (is_numeric($wrk)) {
                $this->DisplayGroups = intval($wrk);
            } elseif (strtoupper($wrk) == "ALL") { // Display all groups
                $this->DisplayGroups = -1;
            }

            // Reset start position (reset command)
            $this->StartGroup = 1;
            $this->setStartGroup($this->StartGroup);
        } elseif ($this->getGroupPerPage() != "") {
            $this->DisplayGroups = $this->getGroupPerPage(); // Restore from session
        }
        $this->setGroupPerPage($this->DisplayGroups); // Save to session
    }

    // Get sort parameters based on sort links clicked
    protected function getSort()
    {
        if ($this->DrillDown) {
            return "";
        }
        $resetSort = Param("cmd") === "resetsort";
        $orderBy = Param("order", "");
        $orderType = Param("ordertype", "");

        // Check for a resetsort command
        if ($resetSort) {
            $this->setOrderBy("");
            $this->setStartGroup(1);
            $this->_23->setSort("");
            $this->Assetsid->setSort("");
            $this->MDA_Parent->setSort("");
            $this->MDA_id->setSort("");
            $this->Location_id->setSort("");
            $this->Details_of_Asset->setSort("");
            $this->Asset_Status->setSort("");
            $this->Condition_Of_Asset->setSort("");
            $this->Custodian_id->setSort("");
            $this->Category->setSort("");
            $this->Category_Details->setSort("");
            $this->Date_of_Acquisition->setSort("");
            $this->Aquistion_Cost->setSort("");
            $this->Additional_Cost->setSort("");
            $this->Revaluation_Cost->setSort("");

        // Check for an Order parameter
        } elseif ($orderBy != "") {
            $this->CurrentOrder = $orderBy;
            $this->CurrentOrderType = $orderType;
            $this->updateSort($this->_23); // #
            $this->updateSort($this->Assetsid); // Assetsid
            $this->updateSort($this->MDA_Parent); // MDA_Parent
            $this->updateSort($this->MDA_id); // MDA_id
            $this->updateSort($this->Location_id); // Location_id
            $this->updateSort($this->Details_of_Asset); // Details_of_Asset
            $this->updateSort($this->Asset_Status); // Asset_Status
            $this->updateSort($this->Condition_Of_Asset); // Condition_Of_Asset
            $this->updateSort($this->Custodian_id); // Custodian_id
            $this->updateSort($this->Category); // Category
            $this->updateSort($this->Category_Details); // Category_Details
            $this->updateSort($this->Date_of_Acquisition); // Date_of_Acquisition
            $this->updateSort($this->Aquistion_Cost); // Aquistion_Cost
            $this->updateSort($this->Additional_Cost); // Additional_Cost
            $this->updateSort($this->Revaluation_Cost); // Revaluation_Cost
            $sortSql = $this->sortSql();
            $this->setOrderBy($sortSql);
            $this->setStartGroup(1);
        }
        return $this->getOrderBy();
    }

    // Return extended filter
    protected function getExtendedFilter()
    {
        $filter = "";
        if ($this->DrillDown) {
            return "";
        }
        $restoreSession = false;
        $restoreDefault = false;
        // Reset search command
        if (Get("cmd", "") == "reset") {
            // Set default values
            $this->MDA_Parent->AdvancedSearch->unsetSession();
            $this->MDA_id->AdvancedSearch->unsetSession();
            $this->Location_id->AdvancedSearch->unsetSession();
            $this->Asset_Status->AdvancedSearch->unsetSession();
            $this->Condition_Of_Asset->AdvancedSearch->unsetSession();
            $this->Custodian_id->AdvancedSearch->unsetSession();
            $this->Category->AdvancedSearch->unsetSession();
            $this->Category_Details->AdvancedSearch->unsetSession();
            $this->Date_of_Acquisition->AdvancedSearch->unsetSession();
            $this->Aquistion_Cost->AdvancedSearch->unsetSession();
            $restoreDefault = true;
        } else {
            $restoreSession = !$this->SearchCommand;

            // Field MDA_Parent
            $this->getDropDownValue($this->MDA_Parent);

            // Field MDA_id
            $this->getDropDownValue($this->MDA_id);

            // Field Location_id
            $this->getDropDownValue($this->Location_id);

            // Field Asset_Status
            $this->getDropDownValue($this->Asset_Status);

            // Field Condition_Of_Asset
            $this->getDropDownValue($this->Condition_Of_Asset);

            // Field Custodian_id
            $this->getDropDownValue($this->Custodian_id);

            // Field Category
            $this->getDropDownValue($this->Category);

            // Field Category_Details
            $this->getDropDownValue($this->Category_Details);

            // Field Date_of_Acquisition
            if ($this->Date_of_Acquisition->AdvancedSearch->get()) {
            }

            // Field Aquistion_Cost
            if ($this->Aquistion_Cost->AdvancedSearch->get()) {
            }
            if (!$this->validateForm()) {
                return $filter;
            }
        }

        // Restore session
        if ($restoreSession) {
            $restoreDefault = true;
            if ($this->MDA_Parent->AdvancedSearch->issetSession()) { // Field MDA_Parent
                $this->MDA_Parent->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->MDA_id->AdvancedSearch->issetSession()) { // Field MDA_id
                $this->MDA_id->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Location_id->AdvancedSearch->issetSession()) { // Field Location_id
                $this->Location_id->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Asset_Status->AdvancedSearch->issetSession()) { // Field Asset_Status
                $this->Asset_Status->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Condition_Of_Asset->AdvancedSearch->issetSession()) { // Field Condition_Of_Asset
                $this->Condition_Of_Asset->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Custodian_id->AdvancedSearch->issetSession()) { // Field Custodian_id
                $this->Custodian_id->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Category->AdvancedSearch->issetSession()) { // Field Category
                $this->Category->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Category_Details->AdvancedSearch->issetSession()) { // Field Category_Details
                $this->Category_Details->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Date_of_Acquisition->AdvancedSearch->issetSession()) { // Field Date_of_Acquisition
                $this->Date_of_Acquisition->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Aquistion_Cost->AdvancedSearch->issetSession()) { // Field Aquistion_Cost
                $this->Aquistion_Cost->AdvancedSearch->load();
                $restoreDefault = false;
            }
        }

        // Restore default
        if ($restoreDefault) {
            $this->loadDefaultFilters();
        }

        // Call page filter validated event
        $this->pageFilterValidated();

        // Build SQL and save to session
        $this->buildDropDownFilter($this->MDA_Parent, $filter, $this->MDA_Parent->AdvancedSearch->SearchOperator, false, true); // Field MDA_Parent
        $this->MDA_Parent->AdvancedSearch->save();
        $this->buildDropDownFilter($this->MDA_id, $filter, $this->MDA_id->AdvancedSearch->SearchOperator, false, true); // Field MDA_id
        $this->MDA_id->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Location_id, $filter, $this->Location_id->AdvancedSearch->SearchOperator, false, true); // Field Location_id
        $this->Location_id->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Asset_Status, $filter, $this->Asset_Status->AdvancedSearch->SearchOperator, false, true); // Field Asset_Status
        $this->Asset_Status->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Condition_Of_Asset, $filter, $this->Condition_Of_Asset->AdvancedSearch->SearchOperator, false, true); // Field Condition_Of_Asset
        $this->Condition_Of_Asset->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Custodian_id, $filter, $this->Custodian_id->AdvancedSearch->SearchOperator, false, true); // Field Custodian_id
        $this->Custodian_id->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Category, $filter, $this->Category->AdvancedSearch->SearchOperator, false, true); // Field Category
        $this->Category->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Category_Details, $filter, $this->Category_Details->AdvancedSearch->SearchOperator, false, true); // Field Category_Details
        $this->Category_Details->AdvancedSearch->save();
        $this->buildExtendedFilter($this->Date_of_Acquisition, $filter, false, true); // Field Date_of_Acquisition
        $this->Date_of_Acquisition->AdvancedSearch->save();
        $this->buildExtendedFilter($this->Aquistion_Cost, $filter, false, true); // Field Aquistion_Cost
        $this->Aquistion_Cost->AdvancedSearch->save();

        // Field MDA_Parent
        LoadDropDownList($this->MDA_Parent->EditValue, $this->MDA_Parent->AdvancedSearch->SearchValue);

        // Field MDA_id
        LoadDropDownList($this->MDA_id->EditValue, $this->MDA_id->AdvancedSearch->SearchValue);

        // Field Location_id
        LoadDropDownList($this->Location_id->EditValue, $this->Location_id->AdvancedSearch->SearchValue);

        // Field Asset_Status
        LoadDropDownList($this->Asset_Status->EditValue, $this->Asset_Status->AdvancedSearch->SearchValue);

        // Field Condition_Of_Asset
        LoadDropDownList($this->Condition_Of_Asset->EditValue, $this->Condition_Of_Asset->AdvancedSearch->SearchValue);

        // Field Custodian_id
        LoadDropDownList($this->Custodian_id->EditValue, $this->Custodian_id->AdvancedSearch->SearchValue);

        // Field Category
        LoadDropDownList($this->Category->EditValue, $this->Category->AdvancedSearch->SearchValue);

        // Field Category_Details
        LoadDropDownList($this->Category_Details->EditValue, $this->Category_Details->AdvancedSearch->SearchValue);
        return $filter;
    }

    // Build dropdown filter
    protected function buildDropDownFilter(&$fld, &$filterClause, $fldOpr, $default = false, $saveFilter = false)
    {
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $sql = "";
        if (is_array($fldVal)) {
            foreach ($fldVal as $val) {
                $wrk = $this->getDropDownFilter($fld, $val, $fldOpr);
                if ($wrk != "") {
                    if ($sql != "") {
                        $sql .= " OR " . $wrk;
                    } else {
                        $sql = $wrk;
                    }
                }
            }
        } else {
            $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
            $sql = $this->getDropDownFilter($fld, $fldVal, $fldOpr, $fldVal2);
        }
        if ($sql != "") {
            AddFilter($filterClause, $sql);
            if ($saveFilter) {
                $fld->CurrentFilter = $sql;
            }
        }
    }

    // Get dropdown filter
    protected function getDropDownFilter(&$fld, $fldVal, $fldOpr, $fldVal2 = "")
    {
        $fldName = $fld->Name;
        $fldExpression = $fld->Expression;
        $fldDataType = $fld->DataType;
        $isMultiple = $fld->HtmlTag == "CHECKBOX" || $fld->HtmlTag == "SELECT" && $fld->SelectMultiple;
        $fldVal = strval($fldVal);
        if ($fldOpr == "") {
            $fldOpr = "=";
        }
        $wrk = "";
        if (SameString($fldVal, Config("NULL_VALUE"))) {
            $wrk = $fldExpression . " IS NULL";
        } elseif (SameString($fldVal, Config("NOT_NULL_VALUE"))) {
            $wrk = $fldExpression . " IS NOT NULL";
        } elseif (SameString($fldVal, EMPTY_VALUE)) {
            $wrk = $fldExpression . " = ''";
        } elseif (SameString($fldVal, ALL_VALUE)) {
            $wrk = "1 = 1";
        } else {
            if ($fld->GroupSql != "") { // Use grouping SQL for search if exists
                $fldExpression = str_replace("%s", $fldExpression, $fld->GroupSql);
            }
            if (StartsString("@@", $fldVal)) {
                $wrk = $this->getCustomFilter($fld, $fldVal, $this->Dbid);
            } elseif ($isMultiple && IsMultiSearchOperator($fldOpr) && trim($fldVal) != "" && $fldVal != INIT_VALUE && ($fldDataType == DATATYPE_NUMBER || $fldDataType == DATATYPE_STRING || $fldDataType == DATATYPE_MEMO)) {
                $wrk = GetMultiSearchSql($fld, $fldOpr, trim($fldVal), $this->Dbid);
            } elseif ($fldOpr == "BETWEEN" && $fldVal != "" && $fldVal != INIT_VALUE && $fldVal2 != "" && $fldVal2 != INIT_VALUE) {
                $wrk = $fldExpression ." " . $fldOpr . " " . QuotedValue($fldVal, $fldDataType, $this->Dbid) . " AND " . QuotedValue($fldVal2, $fldDataType, $this->Dbid);
            } else {
                if ($fldVal != "" && $fldVal != INIT_VALUE) {
                    if ($fldDataType == DATATYPE_DATE && $fld->GroupSql == "" && $fldOpr != "") {
                        $wrk = GetDateFilterSql($fldExpression, $fldOpr, $fldVal, $fldDataType, $this->Dbid);
                    } else {
                        $wrk = GetFilterSql($fldOpr, $fldVal, $fldDataType, $this->Dbid);
                        if ($wrk != "") {
                            $wrk = $fldExpression . $wrk;
                        }
                    }
                }
            }
        }

        // Call Page Filtering event
        if (!StartsString("@@", $fldVal)) {
            $this->pageFiltering($fld, $wrk, "dropdown", $fldOpr, $fldVal);
        }
        return $wrk;
    }

    // Get custom filter
    protected function getCustomFilter(&$fld, $fldVal, $dbid = 0)
    {
        $wrk = "";
        if (is_array($fld->AdvancedFilters)) {
            foreach ($fld->AdvancedFilters as $filter) {
                if ($filter->ID == $fldVal && $filter->Enabled) {
                    $fldExpr = $fld->Expression;
                    $fn = $filter->FunctionName;
                    $wrkid = StartsString("@@", $filter->ID) ? substr($filter->ID, 2) : $filter->ID;
                    $fn = $fn != "" && !function_exists($fn) ? PROJECT_NAMESPACE . $fn : $fn;
                    if (function_exists($fn)) {
                        $wrk = $fn($fldExpr, $dbid);
                    } else {
                        $wrk = "";
                    }
                    $this->pageFiltering($fld, $wrk, "custom", $wrkid);
                    break;
                }
            }
        }
        return $wrk;
    }

    // Build extended filter
    protected function buildExtendedFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $wrk = GetExtendedFilter($fld, $default, $this->Dbid);
        if (!$default) {
            $this->pageFiltering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
        }
        if ($wrk != "") {
            AddFilter($filterClause, $wrk);
            if ($saveFilter) {
                $fld->CurrentFilter = $wrk;
            }
        }
    }

    // Get drop down value from querystring
    protected function getDropDownValue(&$fld)
    {
        $ret = false;
        $parm = $fld->Param;
        if (IsPost()) {
            return false; // Skip post back
        }
        $opr = Get("z_$parm");
        if ($opr !== null) {
            $fld->AdvancedSearch->SearchOperator = $opr;
        }
        $val = Get("x_$parm");
        if ($val !== null) {
            if (is_array($val)) {
                $val = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val);
            }
            $fld->AdvancedSearch->setSearchValue($val);
            $ret = true;
        }
        $val = Get("y_$parm");
        if ($val !== null) {
            if (is_array($val)) {
                $val = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val);
            }
            $fld->AdvancedSearch->setSearchValue2($val);
            $ret = true;
        }
        return $ret;
    }

    // Dropdown filter exist
    protected function dropDownFilterExist(&$fld, $fldOpr)
    {
        $wrk = "";
        $this->buildDropDownFilter($fld, $wrk, $fldOpr);
        return ($wrk != "");
    }

    // Extended filter exist
    protected function extendedFilterExist(&$fld)
    {
        $extWrk = "";
        $this->buildExtendedFilter($fld, $extWrk);
        return ($extWrk != "");
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
                if (!CheckNumber($this->Revaluation_Cost->FormValue)) {
                    $this->Revaluation_Cost->addErrorMessage($this->Revaluation_Cost->getErrorMessage(false));
                }
                if (!CheckNumber($this->Revaluation_Cost->FormValue)) {
                    $this->Revaluation_Cost->addErrorMessage($this->Revaluation_Cost->getErrorMessage(false));
                }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Load default value for filters
    protected function loadDefaultFilters()
    {
        // Field MDA_Parent
        $this->MDA_Parent->AdvancedSearch->loadDefault();

        // Field MDA_id
        $this->MDA_id->AdvancedSearch->loadDefault();

        // Field Location_id
        $this->Location_id->AdvancedSearch->loadDefault();

        // Field Asset_Status
        $this->Asset_Status->AdvancedSearch->loadDefault();

        // Field Condition_Of_Asset
        $this->Condition_Of_Asset->AdvancedSearch->loadDefault();

        // Field Custodian_id
        $this->Custodian_id->AdvancedSearch->loadDefault();

        // Field Category
        $this->Category->AdvancedSearch->loadDefault();

        // Field Category_Details
        $this->Category_Details->AdvancedSearch->loadDefault();

        // Field Date_of_Acquisition
        $this->Date_of_Acquisition->AdvancedSearch->loadDefault();

        // Field Aquistion_Cost
        $this->Aquistion_Cost->AdvancedSearch->loadDefault();
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field MDA_Parent
        $extWrk = "";
        $this->buildDropDownFilter($this->MDA_Parent, $extWrk, $this->MDA_Parent->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->MDA_Parent->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field MDA_id
        $extWrk = "";
        $this->buildDropDownFilter($this->MDA_id, $extWrk, $this->MDA_id->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->MDA_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Location_id
        $extWrk = "";
        $this->buildDropDownFilter($this->Location_id, $extWrk, $this->Location_id->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Location_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Asset_Status
        $extWrk = "";
        $this->buildDropDownFilter($this->Asset_Status, $extWrk, $this->Asset_Status->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Asset_Status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Condition_Of_Asset
        $extWrk = "";
        $this->buildDropDownFilter($this->Condition_Of_Asset, $extWrk, $this->Condition_Of_Asset->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Condition_Of_Asset->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Custodian_id
        $extWrk = "";
        $this->buildDropDownFilter($this->Custodian_id, $extWrk, $this->Custodian_id->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Custodian_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Category
        $extWrk = "";
        $this->buildDropDownFilter($this->Category, $extWrk, $this->Category->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Category->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Category_Details
        $extWrk = "";
        $this->buildDropDownFilter($this->Category_Details, $extWrk, $this->Category_Details->AdvancedSearch->SearchOperator);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Category_Details->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Date_of_Acquisition
        $extWrk = "";
        $this->buildExtendedFilter($this->Date_of_Acquisition, $extWrk);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Date_of_Acquisition->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Aquistion_Cost
        $extWrk = "";
        $this->buildExtendedFilter($this->Aquistion_Cost, $extWrk);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Aquistion_Cost->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"alert alert-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        }
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server" && isset($UserProfile)) {
            $savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fsummary");
        }

        // Field MDA_Parent
        $wrk = "";
        $wrk = ($this->MDA_Parent->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->MDA_Parent->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_MDA_Parent\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field MDA_id
        $wrk = "";
        $wrk = ($this->MDA_id->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->MDA_id->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_MDA_id\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Location_id
        $wrk = "";
        $wrk = ($this->Location_id->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->Location_id->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_Location_id\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Asset_Status
        $wrk = "";
        $wrk = ($this->Asset_Status->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->Asset_Status->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_Asset_Status\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Condition_Of_Asset
        $wrk = "";
        $wrk = ($this->Condition_Of_Asset->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->Condition_Of_Asset->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_Condition_Of_Asset\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Custodian_id
        $wrk = "";
        $wrk = ($this->Custodian_id->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->Custodian_id->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_Custodian_id\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Category
        $wrk = "";
        $wrk = ($this->Category->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->Category->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_Category\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Category_Details
        $wrk = "";
        $wrk = ($this->Category_Details->AdvancedSearch->SearchValue != INIT_VALUE) ? $this->Category_Details->AdvancedSearch->SearchValue : "";
        if (is_array($wrk)) {
            $wrk = implode("||", $wrk);
        }
        if ($wrk != "") {
            $wrk = "\"x_Category_Details\":\"" . JsEncode($wrk) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Date_of_Acquisition
        $wrk = "";
        if ($this->Date_of_Acquisition->AdvancedSearch->SearchValue != "" || $this->Date_of_Acquisition->AdvancedSearch->SearchValue2 != "") {
            $wrk = "\"x_Date_of_Acquisition\":\"" . JsEncode($this->Date_of_Acquisition->AdvancedSearch->SearchValue) . "\"," .
                "\"z_Date_of_Acquisition\":\"" . JsEncode($this->Date_of_Acquisition->AdvancedSearch->SearchOperator) . "\"," .
                "\"v_Date_of_Acquisition\":\"" . JsEncode($this->Date_of_Acquisition->AdvancedSearch->SearchCondition) . "\"," .
                "\"y_Date_of_Acquisition\":\"" . JsEncode($this->Date_of_Acquisition->AdvancedSearch->SearchValue2) . "\"," .
                "\"w_Date_of_Acquisition\":\"" . JsEncode($this->Date_of_Acquisition->AdvancedSearch->SearchOperator2) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field Aquistion_Cost
        $wrk = "";
        if ($this->Aquistion_Cost->AdvancedSearch->SearchValue != "" || $this->Aquistion_Cost->AdvancedSearch->SearchValue2 != "") {
            $wrk = "\"x_Aquistion_Cost\":\"" . JsEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue) . "\"," .
                "\"z_Aquistion_Cost\":\"" . JsEncode($this->Aquistion_Cost->AdvancedSearch->SearchOperator) . "\"," .
                "\"v_Aquistion_Cost\":\"" . JsEncode($this->Aquistion_Cost->AdvancedSearch->SearchCondition) . "\"," .
                "\"y_Aquistion_Cost\":\"" . JsEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue2) . "\"," .
                "\"w_Aquistion_Cost\":\"" . JsEncode($this->Aquistion_Cost->AdvancedSearch->SearchOperator2) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Return filter list in json
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fsummary", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd", "") != "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter", ""), true);
        return $this->setupFilterList($filter);
    }

    // Setup list of filters
    protected function setupFilterList($filter)
    {
        if (!is_array($filter)) {
            return false;
        }

        // Field MDA_Parent
        if (!$this->MDA_Parent->AdvancedSearch->getFromArray($filter)) {
            $this->MDA_Parent->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->MDA_Parent->AdvancedSearch->save();

        // Field MDA_id
        if (!$this->MDA_id->AdvancedSearch->getFromArray($filter)) {
            $this->MDA_id->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->MDA_id->AdvancedSearch->save();

        // Field Location_id
        if (!$this->Location_id->AdvancedSearch->getFromArray($filter)) {
            $this->Location_id->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Location_id->AdvancedSearch->save();

        // Field Asset_Status
        if (!$this->Asset_Status->AdvancedSearch->getFromArray($filter)) {
            $this->Asset_Status->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Asset_Status->AdvancedSearch->save();

        // Field Condition_Of_Asset
        if (!$this->Condition_Of_Asset->AdvancedSearch->getFromArray($filter)) {
            $this->Condition_Of_Asset->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Condition_Of_Asset->AdvancedSearch->save();

        // Field Custodian_id
        if (!$this->Custodian_id->AdvancedSearch->getFromArray($filter)) {
            $this->Custodian_id->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Custodian_id->AdvancedSearch->save();

        // Field Category
        if (!$this->Category->AdvancedSearch->getFromArray($filter)) {
            $this->Category->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Category->AdvancedSearch->save();

        // Field Category_Details
        if (!$this->Category_Details->AdvancedSearch->getFromArray($filter)) {
            $this->Category_Details->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Category_Details->AdvancedSearch->save();

        // Field Date_of_Acquisition
        if (!$this->Date_of_Acquisition->AdvancedSearch->getFromArray($filter)) {
            $this->Date_of_Acquisition->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Date_of_Acquisition->AdvancedSearch->save();

        // Field Aquistion_Cost
        if (!$this->Aquistion_Cost->AdvancedSearch->getFromArray($filter)) {
            $this->Aquistion_Cost->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->Aquistion_Cost->AdvancedSearch->save();
        return true;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
        //$myParent = ExecuteUpdate("UPDATE  detail 
      // SET MDA_Parent=(SELECT Parent FROM mdatbl WHERE assetstbl.MDA_id=mdatbl.MDAID);");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
         echo'<div><h3>EKITI STATE, NIGERIA</h3></div>
    <div><h4>Asset Report 
    Search Parameters</h4></div>';
    $MDAp= $this->MDA_Parent->AdvancedSearch->SearchValue;
    $MDAid= $this->MDA_id->AdvancedSearch->SearchValue;
    // Location
    $Location = $this->Location_id->AdvancedSearch->SearchValue;

    //CHANGE MDAID to Acronyms
    $myField = ExecuteScalar("SELECT MDA_Acronym FROM mdatbl WHERE MDAID = '$MDAid'");
    $MDAid =$myField;

    //CHANGE LocationID to Location Name
    $myField2 = ExecuteScalar("SELECT Location FROM locationtbl WHERE Locationid = '$Location'");
    $Location =$myField2;

    //Category
    $Category= $this->Category->AdvancedSearch->SearchValue; 
    $CategoryDetails= $this->Category_Details->AdvancedSearch->SearchValue;

    //Year_of_Aquistion  	  		
    $Year = $this->Date_of_Acquisition->AdvancedSearch->SearchValue;
    $Year2 = $this->Date_of_Acquisition->AdvancedSearch->SearchValue2;
    $AssetStatus = $this->Asset_Status->AdvancedSearch->SearchValue;
    $ConditionOfAsset = $this->Condition_Of_Asset->AdvancedSearch->SearchValue;
    $Aquistion_Cost = $this->Aquistion_Cost->AdvancedSearch->SearchValue;
    if($MDAp != INIT_VALUE){ echo ' <div> MDA Parent: ' . $MDAp.'<div>';}
    elseif ($MDAid != INIT_VALUE ||$MDAid =='' ) { echo '<div> MDA Parent: All </div>' ;}
    if($MDAid != INIT_VALUE){ echo ' <div> MDA: ' . $MDAid.'<div>';}
    elseif ($MDAid == INIT_VALUE || $MDAid ==''|| is_null($MDAid)  ) { echo '<div> MDA: All </div>' ;}
        if($Location != INIT_VALUE)
        {echo '<div>Location: ' . $Location.'</div>';}
        else if($Location == INIT_VALUE)
        {echo '<div> Location: All  </div>';}
        if($AssetStatus != INIT_VALUE)
        {echo '<div>Usage Status: ' . $AssetStatus.'</div>';}
        else if($AssetStatus == INIT_VALUE)
        {echo '<div> Usage Status: All  </div>';}
        if($ConditionOfAsset != INIT_VALUE)
        {echo '<div>Condition: ' . $ConditionOfAsset.'</div>';}
        else if($ConditionOfAsset == INIT_VALUE)
        {echo '<div> Condition: All  </div>';}
        if ($Category != INIT_VALUE){ echo ' <div> Category: ' . $Category . '(1 Movable, 2 Imovable)</div>';}
       elseif ($Category == INIT_VALUE){ echo '<div> Category: All  </div>';}
            if($CategoryDetails  != INIT_VALUE){ echo '<div> Category Details: ' . $CategoryDetails.'</div>';}
           else if($CategoryDetails == INIT_VALUE){ echo '<div> Category Details: All  </div>';}
      if($Year  != INIT_VALUE && $Year2  != INIT_VALUE){ echo '<div> Date of Acquisition: Between &nbsp' .  $Year. '&nbsp  And &nbsp '  .$Year2.'<div>' ;}
      else if($Year  == INIT_VALUE && $Year2  == INIT_VALUE ||$Year  ='' && $Year2  =''){ echo '<div> Date of Acquisition: All  ' ;}
      date_default_timezone_set('Africa/Lagos');
      echo '<p> (<i>Generated on : '.date("l jS \of F Y h:i:s A").'</i>)</p> </center>';
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
        if ($this->Export == "print") {
        echo'<script type="text/javascript">
     window.onload = function() { window.print(); }
    </script>';
    } 
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"page-break-after:always;\">&nbsp;</div>"; // Modify page break content
    }

    // Load Filters event
    public function pageFilterLoad()
    {
        // Enter your code here
        // Example: Register/Unregister Custom Extended Filter
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', 'GetStartsWithAFilter'); // With function, or
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
        //UnregisterFilter($this-><Field>, 'StartsWithA');
    }

    // Page Selecting event
    public function pageSelecting(&$filter)
    {
        // Enter your code here
    }

    // Page Filter Validated event
    public function pageFilterValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Page Filtering event
    public function pageFiltering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "")
    {
        // Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
        //if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
        //    $filter = "..."; // Modify the filter
    }

    // Cell Rendered event
    public function cellRendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs)
    {
        //$ViewValue = "xxx";
        //$ViewAttrs["class"] = "xxx";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }
}
